/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ChannelSource;
import org.xnio.IoFuture;
import org.xnio.LocalSocketAddress;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioExecutor;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.CloseableChannel;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.SimpleAcceptingChannel;
import org.xnio.channels.StreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.UnsupportedOptionException;

public abstract class XnioWorker
implements CloseableChannel,
XnioExecutor {
    private final Xnio xnio;

    protected XnioWorker(Xnio xnio) {
        this.xnio = xnio;
    }

    public AcceptingChannel<? extends ConnectedStreamChannel> createStreamServer(SocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (bindAddress instanceof InetSocketAddress) {
            return this.createTcpServer((InetSocketAddress)bindAddress, acceptListener, optionMap);
        }
        if (bindAddress instanceof LocalSocketAddress) {
            return this.createLocalStreamServer((LocalSocketAddress)bindAddress, acceptListener, optionMap);
        }
        throw new UnsupportedOperationException("Unsupported socket address " + bindAddress.getClass());
    }

    protected AcceptingChannel<? extends ConnectedStreamChannel> createTcpServer(InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("TCP server");
    }

    protected AcceptingChannel<? extends ConnectedStreamChannel> createLocalStreamServer(LocalSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("UNIX stream server");
    }

    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, OptionMap optionMap) {
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectTcpStream(Xnio.ANY_INET_ADDRESS, (InetSocketAddress)destination, openListener, null, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectLocalStream(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, null, optionMap);
        }
        throw new UnsupportedOperationException("Connect to server with socket address " + destination.getClass());
    }

    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectTcpStream(Xnio.ANY_INET_ADDRESS, (InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectLocalStream(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to server with socket address " + destination.getClass());
    }

    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress bindAddress, SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (bindAddress.getClass() != destination.getClass()) {
            throw new IllegalArgumentException("Bind address " + bindAddress.getClass() + " is not the same type as destination address " + destination.getClass());
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectTcpStream((InetSocketAddress)bindAddress, (InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectLocalStream((LocalSocketAddress)bindAddress, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to stream server with socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedStreamChannel> connectTcpStream(InetSocketAddress bindAddress, InetSocketAddress destinationAddress, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to TCP server");
    }

    protected IoFuture<ConnectedStreamChannel> connectLocalStream(LocalSocketAddress bindAddress, LocalSocketAddress destinationAddress, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to local stream server");
    }

    public IoFuture<ConnectedStreamChannel> acceptStream(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.acceptTcpStream((InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptLocalStream((LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Accept a connection to socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedStreamChannel> acceptLocalStream(LocalSocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOptionException("Accept a local stream connection");
    }

    protected IoFuture<ConnectedStreamChannel> acceptTcpStream(InetSocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOptionException("Accept a TCP connection");
    }

    public IoFuture<ConnectedMessageChannel> connectDatagram(SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectUdpDatagram(Xnio.ANY_INET_ADDRESS, (InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectLocalDatagram(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to datagram server with socket address " + destination.getClass());
    }

    public IoFuture<ConnectedMessageChannel> connectDatagram(SocketAddress bindAddress, SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (bindAddress.getClass() != destination.getClass()) {
            throw new IllegalArgumentException("Bind address " + bindAddress.getClass() + " is not the same type as destination address " + destination.getClass());
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectUdpDatagram((InetSocketAddress)bindAddress, (InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectLocalDatagram((LocalSocketAddress)bindAddress, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to server with socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedMessageChannel> connectUdpDatagram(InetSocketAddress bindAddress, InetSocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to UDP server");
    }

    protected IoFuture<ConnectedMessageChannel> connectLocalDatagram(LocalSocketAddress bindAddress, LocalSocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to local datagram server");
    }

    public IoFuture<ConnectedMessageChannel> acceptDatagram(SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptLocalDatagram((LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Accept a connection to socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedMessageChannel> acceptLocalDatagram(LocalSocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOptionException("Accept a local message connection");
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("UDP Server");
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, OptionMap optionMap) throws IOException {
        return this.createUdpServer(bindAddress, ChannelListeners.nullChannelListener(), optionMap);
    }

    public ChannelSource<? extends StreamChannel> createPipeServer(ChannelListener<? super SimpleAcceptingChannel<StreamChannel>> acceptListener) {
        throw new UnsupportedOperationException("Pipe Server");
    }

    public ChannelSource<? extends StreamSourceChannel> createPipeSourceServer(ChannelListener<? super SimpleAcceptingChannel<StreamSinkChannel>> acceptListener) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public ChannelSource<? extends StreamSinkChannel> createPipeSinkServer(ChannelListener<? super SimpleAcceptingChannel<StreamSourceChannel>> acceptListener) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    @Override
    public abstract boolean isOpen();

    @Override
    public abstract void close() throws IOException;

    @Override
    public XnioWorker getWorker() {
        return this;
    }

    public Xnio getXnio() {
        return this.xnio;
    }
}

