/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.log;

import java.util.logging.LogRecord;

public final class Logger {
    public static final java.util.logging.Level TRACE = new Level("TRACE", 400);
    public static final java.util.logging.Level DEBUG = new Level("DEBUG", 500);
    public static final java.util.logging.Level INFO = new Level("INFO", 800);
    public static final java.util.logging.Level WARN = new Level("WARN", 900);
    public static final java.util.logging.Level ERROR = new Level("ERROR", 1000);
    private final java.util.logging.Logger logger;
    private final String name;

    private Logger(String name) {
        Init.class.getName();
        this.name = name;
        this.logger = java.util.logging.Logger.getLogger(name);
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    public static Logger getLogger(Class claxx) {
        return Logger.getLogger(claxx.getName());
    }

    public boolean isTrace() {
        return this.logger.isLoggable(TRACE);
    }

    private void doLog(java.util.logging.Level level, String msg, Throwable ex, Object[] params) {
        try {
            if (this.logger.isLoggable(level)) {
                String fmtMsg = params != null && params.length > 0 ? String.format(msg, params) : msg;
                LogRecord record = new LogRecord(level, fmtMsg);
                record.setLoggerName(this.name);
                if (ex != null) {
                    record.setThrown(ex);
                }
                record.setSourceMethodName("");
                record.setSourceClassName("");
                this.logger.log(record);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public void error(String msg) {
        this.doLog(ERROR, msg, null, null);
    }

    public void error(Throwable ex, String msg, Object ... params) {
        this.doLog(ERROR, msg, ex, params);
    }

    public void error(String msg, Object ... params) {
        this.doLog(ERROR, msg, null, params);
    }

    public void warn(String msg) {
        this.doLog(WARN, msg, null, null);
    }

    public void warn(Throwable ex, String msg, Object ... params) {
        this.doLog(WARN, msg, ex, params);
    }

    public void warn(String msg, Object ... params) {
        this.doLog(WARN, msg, null, params);
    }

    public void info(String msg) {
        this.doLog(INFO, msg, null, null);
    }

    public void info(Throwable ex, String msg, Object ... params) {
        this.doLog(INFO, msg, ex, params);
    }

    public void info(String msg, Object ... params) {
        this.doLog(INFO, msg, null, params);
    }

    public void debug(String msg) {
        this.doLog(DEBUG, msg, null, null);
    }

    public void debug(Throwable ex, String msg, Object ... params) {
        this.doLog(DEBUG, msg, ex, params);
    }

    public void debug(String msg, Object ... params) {
        this.doLog(DEBUG, msg, null, params);
    }

    public void trace(String msg) {
        this.doLog(TRACE, msg, null, null);
    }

    public void trace(Throwable ex, String msg, Object ... params) {
        this.doLog(TRACE, msg, ex, params);
    }

    public void trace(String msg, Object ... params) {
        this.doLog(TRACE, msg, null, params);
    }

    static final class Level
    extends java.util.logging.Level {
        private static final long serialVersionUID = 2595049467798273809L;

        protected Level(String name, int value) {
            super(name, value);
        }
    }

    private static final class Init {
        private Init() {
        }

        static {
            Logger.getLogger("org.jboss.xnio").info("XNIO Version 1.1.1.GA");
        }
    }
}

