/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import org.jboss.xnio.AbstractConvertingIoFuture;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.channels.AllocatedMessageChannel;
import org.jboss.xnio.channels.AllocatedMessageChannelStreamChannelHandler;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.SuspendableChannel;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Channels {
    private static final Logger log = Logger.getLogger(Channels.class);

    private Channels() {
    }

    public static ChannelSource<AllocatedMessageChannel> convertStreamToAllocatedMessage(final ChannelSource<? extends StreamChannel> streamChannelSource, final int maxInboundMessageSize, final int maxOutboundMessageSize) {
        return new ChannelSource<AllocatedMessageChannel>(){

            @Override
            public IoFuture<AllocatedMessageChannel> open(IoHandler<? super AllocatedMessageChannel> handler) {
                final AllocatedMessageChannelStreamChannelHandler innerHandler = new AllocatedMessageChannelStreamChannelHandler(handler, maxInboundMessageSize, maxOutboundMessageSize);
                return new AbstractConvertingIoFuture<AllocatedMessageChannel, StreamChannel>(streamChannelSource.open(innerHandler)){

                    @Override
                    protected AllocatedMessageChannel convert(StreamChannel arg) {
                        return innerHandler.getChannel(arg);
                    }
                };
            }
        };
    }

    public static IoHandlerFactory<StreamChannel> convertStreamToAllocatedMessage(final IoHandlerFactory<? super AllocatedMessageChannel> handlerFactory, final int maxInboundMessageSize, final int maxOutboundMessageSize) {
        return new IoHandlerFactory<StreamChannel>(){

            @Override
            public IoHandler<? super StreamChannel> createHandler() {
                return new AllocatedMessageChannelStreamChannelHandler(handlerFactory.createHandler(), maxInboundMessageSize, maxOutboundMessageSize);
            }
        };
    }

    public static <T extends SuspendableChannel> IoHandler<T> createMergedHandler(final IoHandler<? super T> readSide, final IoHandler<? super T> writeSide) {
        return new IoHandler<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleOpened(T channel) {
                readSide.handleOpened(channel);
                boolean ok = false;
                try {
                    writeSide.handleOpened(channel);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        try {
                            readSide.handleClosed(channel);
                        }
                        catch (Throwable t) {
                            log.error(t, "Error in close handler", new Object[0]);
                        }
                    }
                }
            }

            @Override
            public void handleReadable(T channel) {
                readSide.handleReadable(channel);
            }

            @Override
            public void handleWritable(T channel) {
                writeSide.handleReadable(channel);
            }

            @Override
            public void handleClosed(T channel) {
                try {
                    readSide.handleClosed(channel);
                }
                catch (Throwable t) {
                    log.error(t, "Error in close handler", new Object[0]);
                }
                try {
                    writeSide.handleClosed(channel);
                }
                catch (Throwable t) {
                    log.error(t, "Error in close handler", new Object[0]);
                }
            }
        };
    }

    public static <T extends SuspendableChannel> IoHandlerFactory<T> createMergedHandlerFactory(final IoHandlerFactory<? super T> readFactory, final IoHandlerFactory<? super T> writeFactory) {
        return new IoHandlerFactory<T>(){

            @Override
            public IoHandler<T> createHandler() {
                return Channels.createMergedHandler(readFactory.createHandler(), writeFactory.createHandler());
            }
        };
    }
}

