/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit5.auto;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Singleton;
import org.jboss.weld.util.annotated.ForwardingAnnotatedType;

public class TestInstanceInjectionExtension
implements Extension {
    private static final AnnotationLiteral<Singleton> SINGLETON_LITERAL = new AnnotationLiteral<Singleton>(){};
    private Class<?> testClass;
    private Object testInstance;

    TestInstanceInjectionExtension(Class<?> testClass, Object testInstance) {
        this.testClass = testClass;
        this.testInstance = testInstance;
    }

    <T> void rewriteTestClassScope(@Observes ProcessAnnotatedType<T> pat, BeanManager beanManager) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        if (annotatedType.getJavaClass().equals(this.testClass)) {
            Set<Annotation> annotations = annotatedType.getAnnotations().stream().filter(annotation -> beanManager.isScope(annotation.annotationType())).collect(Collectors.toSet());
            annotations.add((Annotation)SINGLETON_LITERAL);
            pat.setAnnotatedType(new AnnotationRewritingAnnotatedType(annotatedType, annotations));
        }
    }

    <T> void rewriteTestClassInjections(@Observes ProcessInjectionTarget<T> pit) {
        if (pit.getAnnotatedType().getJavaClass().equals(this.testClass)) {
            final InjectionTarget wrapped = pit.getInjectionTarget();
            pit.setInjectionTarget(new InjectionTarget<T>(){

                public T produce(CreationalContext<T> creationalContext) {
                    return TestInstanceInjectionExtension.this.testInstance;
                }

                public void dispose(T t) {
                    wrapped.dispose(t);
                }

                public Set<InjectionPoint> getInjectionPoints() {
                    return wrapped.getInjectionPoints();
                }

                public void inject(T t, CreationalContext<T> creationalContext) {
                    wrapped.inject(t, creationalContext);
                }

                public void postConstruct(T t) {
                    wrapped.postConstruct(t);
                }

                public void preDestroy(T t) {
                    wrapped.preDestroy(t);
                }
            });
        }
    }

    private static final class AnnotationRewritingAnnotatedType<T>
    extends ForwardingAnnotatedType<T> {
        private AnnotatedType<T> delegate;
        private Set<Annotation> annotations;

        public AnnotationRewritingAnnotatedType(AnnotatedType<T> delegate, Set<Annotation> annotations) {
            this.delegate = delegate;
            this.annotations = annotations;
        }

        public AnnotatedType<T> delegate() {
            return this.delegate;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }
    }
}

