/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.inject;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;

public abstract class AbstractInjector {
    private final WeldManager manager;
    private final ComputingCache<Class<?>, InjectionTarget<?>> cache;

    protected AbstractInjector(final WeldManager manager) {
        Preconditions.checkArgumentNotNull(manager, "manager");
        this.manager = manager;
        this.cache = ComputingCacheBuilder.newBuilder().setWeakValues().build(new Function<Class<?>, InjectionTarget<?>>(){

            @Override
            public InjectionTarget<?> apply(Class<?> key) {
                AnnotatedType<?> type = manager.createAnnotatedType(key);
                return manager.createInjectionTargetBuilder(type).setResourceInjectionEnabled(false).setTargetClassLifecycleCallbacksEnabled(false).build();
            }
        });
    }

    protected void inject(Object instance) {
        InjectionTarget it = (InjectionTarget)this.cache.getCastValue(instance.getClass());
        WeldCreationalContext cc = this.manager.createCreationalContext(null);
        it.inject(instance, cc);
    }

    public void destroy(Object instance) {
        if (instance != null) {
            InjectionTarget it = (InjectionTarget)this.cache.getCastValue(instance.getClass());
            it.dispose(instance);
        }
    }
}

