/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Named;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.WeldCollections;

public class QualifierInstance {
    public static final QualifierInstance ANY = new QualifierInstance(Any.class);
    public static final QualifierInstance DEFAULT = new QualifierInstance(Default.class);
    private final Class<? extends Annotation> annotationClass;
    private final Map<String, Object> values;
    private final int hashCode;

    public static Set<QualifierInstance> of(Set<Annotation> qualifiers, MetaAnnotationStore store) {
        if (qualifiers.isEmpty()) {
            return Collections.emptySet();
        }
        ArraySet<QualifierInstance> ret = new ArraySet<QualifierInstance>();
        for (Annotation a : qualifiers) {
            ret.add(QualifierInstance.of(a, store));
        }
        return WeldCollections.immutableSet(ret);
    }

    public static Set<QualifierInstance> of(Bean<?> bean, MetaAnnotationStore store) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).getQualifierInstances();
        }
        return QualifierInstance.of(bean.getQualifiers(), store);
    }

    public static QualifierInstance of(Annotation annotation, MetaAnnotationStore store) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (Any.class == annotationType) {
            return ANY;
        }
        if (Default.class == annotationType) {
            return DEFAULT;
        }
        if (Named.class == annotationType) {
            Named named = (Named)annotation;
            return new QualifierInstance(annotationType, ImmutableMap.of("value", named.value()));
        }
        return new QualifierInstance(annotationType, QualifierInstance.createValues(annotation, store));
    }

    private QualifierInstance(Class<? extends Annotation> annotationClass) {
        this(annotationClass, Collections.emptyMap());
    }

    private QualifierInstance(Class<? extends Annotation> annotationClass, Map<String, Object> values) {
        this.annotationClass = annotationClass;
        this.values = values;
        this.hashCode = Objects.hashCode(annotationClass, values);
    }

    private static Map<String, Object> createValues(Annotation instance, MetaAnnotationStore store) {
        Class<? extends Annotation> annotationClass = instance.annotationType();
        QualifierModel<? extends Annotation> model = store.getBindingTypeModel(annotationClass);
        if (model.getAnnotatedAnnotation().getMethods().size() == 0) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        for (AnnotatedMethod method : model.getAnnotatedAnnotation().getMethods()) {
            if (model.getNonBindingMembers().contains(method)) continue;
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(SetAccessibleAction.of(method.getJavaMember()));
                } else {
                    method.getJavaMember().setAccessible(true);
                }
                builder.put(method.getJavaMember().getName(), method.getJavaMember().invoke((Object)instance, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new WeldException(e);
            }
            catch (InvocationTargetException e) {
                throw new WeldException(e);
            }
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifierInstance that = (QualifierInstance)o;
        if (!this.annotationClass.equals(that.annotationClass)) {
            return false;
        }
        return this.values.equals(that.values);
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "QualifierInstance {annotationClass=" + this.annotationClass + ", values=" + this.values + '}';
    }
}

