/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import com.google.common.collect.Iterables;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.weld.manager.api.ExecutorServices;

public abstract class IterativeWorkerTaskFactory<T>
implements ExecutorServices.TaskFactory<Void> {
    private final Queue<T> queue = new ConcurrentLinkedQueue<T>();

    public IterativeWorkerTaskFactory(Iterable<? extends T> iterable) {
        Iterables.addAll(this.queue, iterable);
    }

    @Override
    public List<Callable<Void>> createTasks(int threadPoolSize) {
        int taskCount = Runtime.getRuntime().availableProcessors();
        if (threadPoolSize > 0) {
            taskCount = Math.min(Runtime.getRuntime().availableProcessors(), threadPoolSize);
        }
        LinkedList<Callable<Void>> tasks = new LinkedList<Callable<Void>>();
        for (int i = 0; i < taskCount; ++i) {
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    IterativeWorkerTaskFactory.this.init();
                    Thread thread = Thread.currentThread();
                    Object i = IterativeWorkerTaskFactory.this.queue.poll();
                    while (i != null && !thread.isInterrupted()) {
                        IterativeWorkerTaskFactory.this.doWork(i);
                        i = IterativeWorkerTaskFactory.this.queue.poll();
                    }
                    IterativeWorkerTaskFactory.this.cleanup();
                    return null;
                }
            });
        }
        return tasks;
    }

    protected void init() {
    }

    protected void cleanup() {
    }

    protected abstract void doWork(T var1);

    public Queue<T> getQueue() {
        return this.queue;
    }
}

