/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.weld.bootstrap.api;

/**
 * Marks a {@link Service} that needs to clean up its state once bootstrap is finished.
 *
 * @author Jozef Hartinger
 *
 */
public interface BootstrapService extends Service {

    /**
     * Called by Weld once it finishes initialization and before it starts serving requests. This method is not guaranteed to be
     * called by Weld if the deployment fails with an error.
     */
    void cleanupAfterBoot();
}
