/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.inject.Inject;
import javax.interceptor.Interceptor;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.enablement.ModuleEnablement;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ResourceInjection;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionTypeRegistry;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.MergedStereotypes;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SessionBeanHierarchyDiscovery;
import org.slf4j.cal10n.LocLogger;

public class Beans {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);

    private Beans() {
    }

    public static boolean isPassivatingScope(Bean<?> bean, BeanManagerImpl manager) {
        if (bean == null) {
            return false;
        }
        return manager.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isPassivating();
    }

    public static boolean isPassivationCapableBean(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isPassivationCapableBean();
        }
        return bean instanceof PassivationCapable;
    }

    public static boolean isPassivationCapableDependency(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isPassivationCapableDependency();
        }
        return bean instanceof PassivationCapable;
    }

    public static boolean isBeanProxyable(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyable();
        }
        return Proxies.isTypesProxyable(bean.getTypes());
    }

    public static List<AnnotatedMethod<?>> getInterceptableMethods(AnnotatedType<?> type) {
        ArrayList annotatedMethods = new ArrayList();
        for (AnnotatedMethod<?> annotatedMethod : type.getMethods()) {
            boolean businessMethod = !annotatedMethod.isStatic() && !annotatedMethod.isAnnotationPresent(Inject.class) && !annotatedMethod.getJavaMember().isBridge();
            if (!businessMethod || Beans.isInterceptorMethod(annotatedMethod)) continue;
            annotatedMethods.add(annotatedMethod);
        }
        return annotatedMethods;
    }

    private static boolean isInterceptorMethod(AnnotatedMethod<?> annotatedMethod) {
        for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
            if (!annotatedMethod.isAnnotationPresent(InterceptionTypeRegistry.getAnnotationClass(interceptionType))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllQualifiers(Set<QualifierInstance> requiredQualifiers, Set<QualifierInstance> qualifiers) {
        return qualifiers.containsAll(requiredQualifiers);
    }

    public static boolean containsAllInterceptionBindings(Set<Annotation> expectedBindings, Set<QualifierInstance> existingBindings, BeanManagerImpl manager) {
        Set<QualifierInstance> expected = manager.extractInterceptorBindingsForQualifierInstance(QualifierInstance.qualifiers(manager, expectedBindings));
        return manager.extractInterceptorBindingsForQualifierInstance(existingBindings).containsAll(expected);
    }

    public static boolean findInterceptorBindingConflicts(BeanManagerImpl manager, Set<Annotation> bindings) {
        HashMap<Class<? extends Annotation>, Annotation> foundAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation binding : bindings) {
            if (foundAnnotations.containsKey(binding.annotationType())) {
                InterceptorBindingModel<? extends Annotation> bindingType = manager.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(binding.annotationType());
                if (bindingType.isEqual(binding, (Annotation)foundAnnotations.get(binding.annotationType()), false)) continue;
                return true;
            }
            foundAnnotations.put(binding.annotationType(), binding);
        }
        return false;
    }

    public static <T extends Bean<?>> Set<T> removeDisabledBeans(Set<T> beans, final BeanManagerImpl beanManager, SpecializationAndEnablementRegistry registry) {
        if (beans.size() == 0) {
            return beans;
        }
        return Sets.filter(beans, new Predicate<T>(){

            @Override
            public boolean apply(T bean) {
                return Beans.isBeanEnabled(bean, beanManager.getEnabled());
            }
        });
    }

    public static boolean isBeanEnabled(Bean<?> bean, ModuleEnablement enabled) {
        if (bean.isAlternative()) {
            if (enabled.isEnabledAlternativeClass(bean.getBeanClass())) {
                return true;
            }
            for (Class<Annotation> stereotype : bean.getStereotypes()) {
                if (!enabled.isEnabledAlternativeStereotype(stereotype)) continue;
                return true;
            }
            return false;
        }
        if (bean instanceof AbstractProducerBean) {
            AbstractProducerBean receiverBean = (AbstractProducerBean)bean;
            return Beans.isBeanEnabled(receiverBean.getDeclaringBean(), enabled);
        }
        if (bean instanceof DecoratorImpl) {
            return enabled.isDecoratorEnabled(bean.getBeanClass());
        }
        if (bean instanceof InterceptorImpl) {
            return enabled.isInterceptorEnabled(bean.getBeanClass());
        }
        return true;
    }

    public static boolean isAlternativePresent(Set<Bean<?>> beans) {
        for (Bean<?> bean : beans) {
            if (!bean.isAlternative()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAlternative(EnhancedAnnotated<?, ?> annotated, MergedStereotypes<?, ?> mergedStereotypes) {
        return annotated.isAnnotationPresent(Alternative.class) || mergedStereotypes.isAlternative();
    }

    public static <T> EnhancedAnnotatedConstructor<T> getBeanConstructorStrict(EnhancedAnnotatedType<T> type) {
        EnhancedAnnotatedConstructor<T> constructor = Beans.getBeanConstructor(type);
        if (constructor == null) {
            throw new DefinitionException(UtilMessage.UNABLE_TO_FIND_CONSTRUCTOR, type);
        }
        return constructor;
    }

    public static <T> EnhancedAnnotatedConstructor<T> getBeanConstructor(EnhancedAnnotatedType<T> type) {
        Collection<EnhancedAnnotatedConstructor<T>> initializerAnnotatedConstructors = type.getEnhancedConstructors(Inject.class);
        log.trace(BeanMessage.FOUND_INJECTABLE_CONSTRUCTORS, initializerAnnotatedConstructors, type);
        EnhancedAnnotatedConstructor<T> constructor = null;
        if (initializerAnnotatedConstructors.size() > 1) {
            throw new DefinitionException(UtilMessage.AMBIGUOUS_CONSTRUCTOR, type, initializerAnnotatedConstructors);
        }
        if (initializerAnnotatedConstructors.size() == 1) {
            constructor = initializerAnnotatedConstructors.iterator().next();
            log.trace(BeanMessage.FOUND_ONE_INJECTABLE_CONSTRUCTOR, constructor, type);
        } else if (type.getNoArgsEnhancedConstructor() != null) {
            constructor = type.getNoArgsEnhancedConstructor();
            log.trace(BeanMessage.FOUND_DEFAULT_CONSTRUCTOR, constructor, type);
        }
        if (constructor != null) {
            if (!constructor.getEnhancedParameters(Disposes.class).isEmpty()) {
                throw new DefinitionException(BeanMessage.PARAMETER_ANNOTATION_NOT_ALLOWED_ON_CONSTRUCTOR, "@Disposes", constructor);
            }
            if (!constructor.getEnhancedParameters(Observes.class).isEmpty()) {
                throw new DefinitionException(BeanMessage.PARAMETER_ANNOTATION_NOT_ALLOWED_ON_CONSTRUCTOR, "@Observes", constructor);
            }
        }
        return constructor;
    }

    public static <T> void injectEEFields(Iterable<Set<ResourceInjection<?>>> resourceInjectionsHierarchy, T beanInstance, CreationalContext<T> ctx) {
        for (Set<ResourceInjection<?>> resourceInjections : resourceInjectionsHierarchy) {
            for (ResourceInjection<T> resourceInjection : resourceInjections) {
                resourceInjection.injectResourceReference(beanInstance, ctx);
            }
        }
    }

    public static Type getDeclaredBeanType(Class<?> clazz) {
        Type[] actualTypeArguments = Reflections.getActualTypeArguments(clazz);
        if (actualTypeArguments.length == 1) {
            return actualTypeArguments[0];
        }
        return null;
    }

    public static <T> void injectBoundFields(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<? extends FieldInjectionPoint<?, ?>> injectableFields) {
        for (FieldInjectionPoint<T, T> fieldInjectionPoint : injectableFields) {
            fieldInjectionPoint.inject(instance, manager, creationalContext);
        }
    }

    public static <T> void injectFieldsAndInitializers(T instance, CreationalContext<T> ctx, BeanManagerImpl beanManager, List<? extends Iterable<? extends FieldInjectionPoint<?, ?>>> injectableFields, List<? extends Iterable<? extends MethodInjectionPoint<?, ?>>> initializerMethods) {
        if (injectableFields.size() != initializerMethods.size()) {
            throw new IllegalArgumentException(UtilMessage.INVALID_QUANTITY_INJECTABLE_FIELDS_AND_INITIALIZER_METHODS, injectableFields, initializerMethods);
        }
        for (int i = 0; i < injectableFields.size(); ++i) {
            Beans.injectBoundFields(instance, ctx, beanManager, injectableFields.get(i));
            Beans.callInitializers(instance, ctx, beanManager, initializerMethods.get(i));
        }
    }

    public static <T> void callInitializers(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<? extends MethodInjectionPoint<?, ?>> initializerMethods) {
        for (MethodInjectionPoint<T, T> methodInjectionPoint : initializerMethods) {
            methodInjectionPoint.invoke(instance, manager, creationalContext, CreationException.class);
        }
    }

    public static <T> boolean isInterceptor(AnnotatedType<T> annotatedItem) {
        return annotatedItem.isAnnotationPresent(Interceptor.class);
    }

    public static <T> boolean isDecorator(EnhancedAnnotatedType<T> annotatedItem) {
        return annotatedItem.isAnnotationPresent(Decorator.class);
    }

    public static Annotation[] mergeInQualifiers(Annotation[] qualifiers, Annotation[] newQualifiers) {
        if (qualifiers == null || newQualifiers == null) {
            return Reflections.EMPTY_ANNOTATIONS;
        }
        return Beans.mergeInQualifiers(Arrays.asList(qualifiers), newQualifiers).toArray(Reflections.EMPTY_ANNOTATIONS);
    }

    public static Set<Annotation> mergeInQualifiers(Collection<Annotation> qualifiers, Annotation[] newQualifiers) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        if (qualifiers != null && !qualifiers.isEmpty()) {
            result.addAll(qualifiers);
        }
        if (newQualifiers != null && newQualifiers.length > 0) {
            MetaAnnotationStore store = Container.instance().services().get(MetaAnnotationStore.class);
            HashSet<Annotation> checkedNewQualifiers = new HashSet<Annotation>();
            for (Annotation qualifier : newQualifiers) {
                if (!store.getBindingTypeModel(qualifier.annotationType()).isValid()) {
                    throw new IllegalArgumentException(UtilMessage.ANNOTATION_NOT_QUALIFIER, qualifier);
                }
                if (checkedNewQualifiers.contains(qualifier)) {
                    throw new IllegalArgumentException(UtilMessage.REDUNDANT_QUALIFIER, qualifier, Arrays.asList(newQualifiers));
                }
                checkedNewQualifiers.add(qualifier);
            }
            result.addAll(checkedNewQualifiers);
        }
        return result;
    }

    public static Set<Type> getTypes(EnhancedAnnotated<?, ?> annotated) {
        if (annotated.getJavaClass().isArray() || annotated.getJavaClass().isPrimitive()) {
            return new ArraySet<Type>(annotated.getBaseType(), Object.class);
        }
        if (annotated.isAnnotationPresent(Typed.class)) {
            return new ArraySet<Type>((Collection<Type>)Beans.getTypedTypes(Reflections.buildTypeMap(annotated.getTypeClosure()), annotated.getJavaClass(), annotated.getAnnotation(Typed.class)));
        }
        if (annotated.getJavaClass().isInterface()) {
            return new ArraySet<Type>((Collection<Type>)annotated.getTypeClosure(), (E[])new Type[]{Object.class});
        }
        return annotated.getTypeClosure();
    }

    public static <T> Set<Type> getTypes(EnhancedAnnotated<T, ?> annotated, EjbDescriptor<T> ejbDescriptor) {
        ArraySet<Type> types = new ArraySet<Type>();
        LinkedHashMap typeMap = new LinkedHashMap();
        HierarchyDiscovery beanClassDiscovery = new HierarchyDiscovery(ejbDescriptor.getBeanClass());
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : ejbDescriptor.getLocalBusinessInterfaces()) {
            Type resolvedLocalInterface = beanClassDiscovery.resolveType(Types.getCanonicalType(businessInterfaceDescriptor.getInterface()));
            SessionBeanHierarchyDiscovery interfaceDiscovery = new SessionBeanHierarchyDiscovery(resolvedLocalInterface);
            typeMap.putAll(interfaceDiscovery.getTypeMap());
        }
        if (annotated.isAnnotationPresent(Typed.class)) {
            types.addAll((Collection<Type>)Beans.getTypedTypes(typeMap, annotated.getJavaClass(), annotated.getAnnotation(Typed.class)));
        } else {
            typeMap.put(Object.class, (Type)((Object)Object.class));
            types.addAll(typeMap.values());
        }
        return WeldCollections.immutableSet(types);
    }

    public static Set<Type> getTypedTypes(Map<Class<?>, Type> typeClosure, Class<?> rawType, Typed typed) {
        HashSet<Type> types = new HashSet<Type>();
        for (Class<?> specifiedClass : typed.value()) {
            Type tmp = typeClosure.get(specifiedClass);
            if (tmp == null) {
                throw new DefinitionException(BeanMessage.TYPED_CLASS_NOT_IN_HIERARCHY, specifiedClass.getName(), rawType);
            }
            types.add(tmp);
        }
        types.add((Type)((Object)Object.class));
        return types;
    }

    public static boolean isTypeManagedBeanOrDecoratorOrInterceptor(AnnotatedType<?> annotatedType) {
        Class<?> javaClass = annotatedType.getJavaClass();
        return !javaClass.isEnum() && !Extension.class.isAssignableFrom(javaClass) && !Reflections.isNonStaticInnerClass(javaClass) && !Reflections.isParamerterizedTypeWithWildcard(javaClass) && Beans.hasSimpleCdiConstructor(annotatedType);
    }

    public static boolean hasSimpleCdiConstructor(AnnotatedType<?> type) {
        for (AnnotatedConstructor<?> constructor : type.getConstructors()) {
            if (constructor.getParameters().isEmpty()) {
                return true;
            }
            if (!constructor.isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVetoed(Class<?> javaClass) {
        if (javaClass.isAnnotationPresent(Vetoed.class)) {
            return true;
        }
        return Beans.isPackageVetoed(javaClass.getPackage());
    }

    public static boolean isVetoed(AnnotatedType<?> type) {
        if (type.isAnnotationPresent(Vetoed.class)) {
            return true;
        }
        return Beans.isPackageVetoed(type.getJavaClass().getPackage());
    }

    private static boolean isPackageVetoed(Package pkg) {
        return pkg != null && pkg.isAnnotationPresent(Vetoed.class);
    }

    public static String createBeanAttributesId(BeanAttributes<?> attributes) {
        StringBuilder builder = new StringBuilder();
        builder.append(attributes.getName());
        builder.append(",");
        builder.append(attributes.getScope().getName());
        builder.append(",");
        builder.append(attributes.isAlternative());
        builder.append(AnnotatedTypes.createAnnotationCollectionId(attributes.getQualifiers()));
        builder.append(Beans.createTypeCollectionId(attributes.getStereotypes()));
        builder.append(Beans.createTypeCollectionId(attributes.getTypes()));
        return builder.toString();
    }

    public static String createTypeCollectionId(Collection<? extends Type> types) {
        StringBuilder builder = new StringBuilder();
        ArrayList<? extends Type> sortedTypes = new ArrayList<Type>(types);
        Collections.sort(sortedTypes, TypeComparator.INSTANCE);
        builder.append("[");
        Iterator iterator = sortedTypes.iterator();
        while (iterator.hasNext()) {
            builder.append(Beans.createTypeId((Type)iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    private static String createTypeId(Type type) {
        if (type instanceof Class) {
            return ((Class)Reflections.cast(type)).getName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder();
            builder.append(Beans.createTypeId(parameterizedType.getRawType()));
            builder.append("<");
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                builder.append(Beans.createTypeId(parameterizedType.getActualTypeArguments()[i]));
                if (i == parameterizedType.getActualTypeArguments().length - 1) continue;
                builder.append(",");
            }
            builder.append(">");
            return builder.toString();
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)Reflections.cast(type)).getName();
        }
        if (type instanceof GenericArrayType) {
            return Beans.createTypeId(((GenericArrayType)Reflections.cast(type)).getGenericComponentType());
        }
        throw new java.lang.IllegalArgumentException("Unknown type " + type);
    }

    public static <T, S, X extends EnhancedAnnotated<T, S>> X checkEnhancedAnnotatedAvailable(X enhancedAnnotated) {
        if (enhancedAnnotated == null) {
            throw new IllegalStateException("Enhanced metadata should not be used at runtime.");
        }
        return enhancedAnnotated;
    }

    private static class TypeComparator
    implements Comparator<Type>,
    Serializable {
        private static final long serialVersionUID = -2162735176891985078L;
        private static final TypeComparator INSTANCE = new TypeComparator();

        private TypeComparator() {
        }

        @Override
        public int compare(Type o1, Type o2) {
            return Beans.createTypeId(o1).compareTo(Beans.createTypeId(o2));
        }
    }
}

