/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.conversation;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.inject.Inject;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.ManagedConversation;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.slf4j.cal10n.LocLogger;

public class ConversationImpl
implements ManagedConversation,
Serializable {
    private static final long serialVersionUID = -5566903049468084035L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONVERSATION);
    private String id;
    private boolean _transient;
    private long timeout;
    private ReentrantLock concurrencyLock;
    private long lastUsed;
    private BeanManagerImpl manager;

    @Inject
    public ConversationImpl(BeanManagerImpl manager) {
        this.manager = manager;
        this._transient = true;
        this.timeout = this.isContextActive() ? this.getActiveConversationContext().getDefaultTimeout() : 0L;
        this.concurrencyLock = new ReentrantLock();
        this.touch();
    }

    @Override
    public void begin() {
        this.verifyConversationContextActive();
        if (!this._transient) {
            throw new IllegalStateException(ConversationMessage.BEGIN_CALLED_ON_LONG_RUNNING_CONVERSATION, new Object[0]);
        }
        this._transient = false;
        if (this.id == null) {
            this.id = this.getActiveConversationContext().generateConversationId();
        }
        log.debug(ConversationMessage.PROMOTED_TRANSIENT, this.id);
    }

    @Override
    public void begin(String id) {
        this.verifyConversationContextActive();
        if (!this._transient) {
            throw new IllegalStateException(ConversationMessage.BEGIN_CALLED_ON_LONG_RUNNING_CONVERSATION, new Object[0]);
        }
        if (this.getActiveConversationContext().getConversation(id) != null) {
            throw new IllegalArgumentException(ConversationMessage.CONVERSATION_ID_ALREADY_IN_USE, id);
        }
        this._transient = false;
        this.id = id;
        log.debug(ConversationMessage.PROMOTED_TRANSIENT, id);
    }

    @Override
    public void end() {
        this.verifyConversationContextActive();
        if (this._transient) {
            throw new IllegalStateException(ConversationMessage.END_CALLED_ON_TRANSIENT_CONVERSATION, new Object[0]);
        }
        log.debug(ConversationMessage.DEMOTED_LRC, this.id);
        this._transient = true;
    }

    @Override
    public String getId() {
        this.verifyConversationContextActive();
        if (!this._transient) {
            return this.id;
        }
        return null;
    }

    @Override
    public long getTimeout() {
        this.verifyConversationContextActive();
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.verifyConversationContextActive();
        this.timeout = timeout;
    }

    public String toString() {
        if (this._transient) {
            return "Transient conversation";
        }
        return "Conversation with id: " + this.id;
    }

    @Override
    public boolean isTransient() {
        this.verifyConversationContextActive();
        return this._transient;
    }

    @Override
    public long getLastUsed() {
        this.verifyConversationContextActive();
        return this.lastUsed;
    }

    @Override
    public void touch() {
        this.verifyConversationContextActive();
        this.lastUsed = System.currentTimeMillis();
    }

    @Override
    public boolean lock(long timeout) {
        boolean success;
        this.verifyConversationContextActive();
        try {
            success = this.concurrencyLock.tryLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            success = false;
        }
        if (success) {
            log.trace(ConversationMessage.CONVERSATION_LOCKED, this);
        } else {
            log.warn(ConversationMessage.CONVERSATION_UNAVAILABLE, timeout, this);
        }
        return success;
    }

    @Override
    public boolean unlock() {
        this.verifyConversationContextActive();
        if (!this.concurrencyLock.isLocked()) {
            return true;
        }
        if (this.concurrencyLock.isHeldByCurrentThread()) {
            this.concurrencyLock.unlock();
            log.trace(ConversationMessage.CONVERSATION_UNLOCKED, this);
        } else {
            log.warn(ConversationMessage.ILLEGAL_CONVERSATION_UNLOCK_ATTEMPT, this, "not owner");
        }
        return !this.concurrencyLock.isLocked();
    }

    private void verifyConversationContextActive() {
        if (!this.isContextActive()) {
            throw new ContextNotActiveException("Conversation Context not active when method called on conversation " + this);
        }
    }

    public boolean isContextActive() {
        return this.manager.isContextActive(ConversationScoped.class);
    }

    private ConversationContext getActiveConversationContext() {
        return (ConversationContext)this.manager.getUnwrappedContext(ConversationScoped.class);
    }
}

