package org.jboss.weld.module.web.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.ClassLoader;
import java.lang.Object;
import java.util.Arrays;
import org.jboss.weld.module.web.servlet.ServletContextService;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class ServletLogger_$logger extends DelegatingBasicLogger implements ServletLogger, WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ServletLogger_$logger.class.getName();
    public ServletLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String onlyHttpServletLifecycleDefined$str() {
        return "WELD-000707: Non Http-Servlet lifecycle not defined";
    }
    @Override
    public final IllegalStateException onlyHttpServletLifecycleDefined() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), onlyHttpServletLifecycleDefined$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void requestInitialized(final Object param1) {
        super.log.logv(FQCN, TRACE, null, requestInitialized$str(), param1);
    }
    protected String requestInitialized$str() {
        return "WELD-000708: Initializing request {0}";
    }
    @Override
    public final void requestDestroyed(final Object param1) {
        super.log.logv(FQCN, TRACE, null, requestDestroyed$str(), param1);
    }
    protected String requestDestroyed$str() {
        return "WELD-000709: Destroying request {0}";
    }
    protected String cannotInjectObjectOutsideOfServletRequest$str() {
        return "WELD-000710: Cannot inject {0} outside of a Servlet request";
    }
    @Override
    public final IllegalStateException cannotInjectObjectOutsideOfServletRequest(final Object param1, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(cannotInjectObjectOutsideOfServletRequest$str(), param1), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    @Override
    public final void webXmlMappingPatternIgnored(final String pattern) {
        super.log.logv(FQCN, WARN, null, webXmlMappingPatternIgnored$str(), pattern);
    }
    protected String webXmlMappingPatternIgnored$str() {
        return "WELD-000711: Context activation pattern {0} ignored as it is overriden by the integrator.";
    }
    @Override
    public final void unableToDissociateContext(final Object context, final Object storage) {
        super.log.logv(FQCN, WARN, null, unableToDissociateContext$str(), context, storage);
    }
    protected String unableToDissociateContext$str() {
        return "WELD-000712: Unable to dissociate context {0} from the storage {1}";
    }
    protected String cannotInjectServletContext$str() {
        return "WELD-000713: Unable to inject ServletContext. None is associated with {0}, {1}";
    }
    @Override
    public final IllegalStateException cannotInjectServletContext(final ClassLoader classLoader, final ServletContextService service) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(cannotInjectServletContext$str(), classLoader, service));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void guardLeak(final int value) {
        super.log.logv(FQCN, WARN, null, guardLeak$str(), value);
    }
    protected String guardLeak$str() {
        return "WELD-000714: HttpContextLifecycle guard leak detected. The Servlet container is not fully compliant. The value was {0}";
    }
    @Override
    public final void guardNotSet() {
        super.log.logv(FQCN, WARN, null, guardNotSet$str());
    }
    protected String guardNotSet$str() {
        return "WELD-000715: HttpContextLifecycle guard not set. The Servlet container is not fully compliant.";
    }
    @Override
    public final void servlet2Environment() {
        super.log.logf(FQCN, INFO, null, servlet2Environment$str());
    }
    protected String servlet2Environment$str() {
        return "WELD-000716: Running in Servlet 2.x environment. Asynchronous request support is disabled.";
    }
    @Override
    public final void unableToDeactivateContext(final Object context, final Object request) {
        super.log.logv(FQCN, WARN, null, unableToDeactivateContext$str(), context, request);
    }
    protected String unableToDeactivateContext$str() {
        return "WELD-000717: Unable to deactivate context {0} when destroying request {1}";
    }
    @Override
    public final void noEeModuleDescriptor(final Object beanArchiveId) {
        super.log.logv(FQCN, WARN, null, noEeModuleDescriptor$str(), beanArchiveId);
    }
    protected String noEeModuleDescriptor$str() {
        return "WELD-000718: No EEModuleDescriptor defined for bean archive with ID: {0}. @Initialized and @Destroyed events for ApplicationScoped may be fired twice.";
    }
    @Override
    public final void destructionContextLeak() {
        super.log.logv(FQCN, DEBUG, null, destructionContextLeak$str());
    }
    protected String destructionContextLeak$str() {
        return "WELD-000719: An active HttpSessionDestructionContext detected. This is likely a leftover from previous sessions that ended exceptionally. This context will be terminated.";
    }
    @Override
    public final void catchingDebug(final Throwable arg0) {
        super.log.logf(FQCN, DEBUG, arg0, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
