/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.microcontainer.deployer.env;

import java.net.URL;
import java.util.Collection;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractOptionalVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;
import org.jboss.webbeans.integration.microcontainer.deployer.env.WebBeanDiscoveryEnvironment;
import org.jboss.webbeans.integration.microcontainer.deployer.ext.JBossWebBeansMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeanDiscoveryDeployer
extends AbstractOptionalVFSRealDeployer<JBossWebBeansMetaData> {
    public WebBeanDiscoveryDeployer() {
        super(JBossWebBeansMetaData.class);
        this.addInput("WEB_BEANS_FILES");
        this.addInput("WEB_BEANS_CLASSPATH");
        this.addOutput(WebBeanDiscoveryEnvironment.class);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    public void deploy(VFSDeploymentUnit unit, JBossWebBeansMetaData deployment) throws DeploymentException {
        VFSDeploymentUnit topUnit;
        Collection wbFiles = (Collection)unit.getAttachment("WEB_BEANS_FILES", Collection.class);
        boolean hasWB = wbFiles != null && !wbFiles.isEmpty();
        Collection cpFiles = (Collection)unit.getAttachment("WEB_BEANS_CLASSPATH", Collection.class);
        boolean hasCp = cpFiles != null && !cpFiles.isEmpty();
        WebBeanDiscoveryEnvironment environment = null;
        if ((hasWB || hasCp) && (environment = (WebBeanDiscoveryEnvironment)(topUnit = unit.getTopLevel()).getAttachment(WebBeanDiscoveryEnvironment.class)) == null) {
            environment = new WebBeanDiscoveryEnvironment();
            topUnit.addAttachment(WebBeanDiscoveryEnvironment.class, (Object)environment);
        }
        try {
            if (hasWB) {
                for (VirtualFile file : wbFiles) {
                    environment.addWebBeansXmlURL(file.toURL());
                }
            }
            if (hasCp) {
                Module module = (Module)unit.getAttachment(Module.class);
                if (module == null) {
                    for (VFSDeploymentUnit parent = unit.getParent(); parent != null && module == null; parent = parent.getParent()) {
                        module = (Module)parent.getAttachment(Module.class);
                    }
                    if (module == null) {
                        throw new DeploymentException("No module in deployment unit's hierarchy: " + unit.getName());
                    }
                }
                URL[] urls = new URL[cpFiles.size()];
                int i = 0;
                for (VirtualFile file : cpFiles) {
                    urls[i++] = file.toURL();
                }
                WBDiscoveryVisitor visitor = new WBDiscoveryVisitor(environment);
                module.visit((ResourceVisitor)visitor, (ResourceFilter)ClassFilter.INSTANCE, null, urls);
            }
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot build WB env.", (Throwable)e);
        }
    }

    private class WBDiscoveryVisitor
    implements ResourceVisitor {
        private WebBeanDiscoveryEnvironment wbdi;

        private WBDiscoveryVisitor(WebBeanDiscoveryEnvironment wbdi) {
            this.wbdi = wbdi;
        }

        public ResourceFilter getFilter() {
            return ClassFilter.INSTANCE;
        }

        public void visit(ResourceContext resource) {
            this.wbdi.addWebBeanClass(resource.loadClass());
        }
    }
}

