/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.tomcat.util.net.NioChannel;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.CoyoteMessages;

public class SecureNioChannel
extends NioChannel {
    private static final int MIN_BUFFER_SIZE = 16384;
    protected SSLEngine sslEngine;
    private ByteBuffer netInBuffer;
    private ByteBuffer netOutBuffer;
    protected boolean handshakeComplete = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus;

    protected SecureNioChannel(AsynchronousSocketChannel channel, SSLEngine engine) {
        super(channel);
        if (engine == null) {
            throw CoyoteMessages.MESSAGES.nullSslEngine();
        }
        this.sslEngine = engine;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    @Deprecated
    public Future<Integer> read(ByteBuffer dst) {
        throw CoyoteMessages.MESSAGES.operationNotSupported();
    }

    @Override
    public int readBytes(ByteBuffer dst) throws Exception {
        return this.readBytes(dst, Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public int readBytes(ByteBuffer dst, long timeout, TimeUnit unit) throws Exception {
        this.checkHandshake();
        if (this.netInBuffer.position() == 0) {
            this.reset(this.netInBuffer);
            int x = this.channel.read(this.netInBuffer).get(timeout, unit);
            if (x < 0) {
                throw new ClosedChannelException();
            }
        }
        return this.unwrap(this.netInBuffer, dst);
    }

    @Override
    public <A> void read(ByteBuffer dst, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.read(dst, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, attachment, handler);
    }

    @Override
    public <A> void read(final ByteBuffer dst, long timeout, TimeUnit unit, A attachment, final CompletionHandler<Integer, ? super A> handler) {
        this.checkHandshake();
        this.reset(this.netInBuffer);
        this.channel.read(this.netInBuffer, timeout, unit, attachment, new CompletionHandler<Integer, A>(){

            @Override
            public void completed(Integer nBytes, A attach) {
                if (nBytes < 0) {
                    handler.failed(new ClosedChannelException(), attach);
                    return;
                }
                try {
                    int read = SecureNioChannel.this.unwrap(SecureNioChannel.this.netInBuffer, dst);
                    handler.completed(read, attach);
                }
                catch (Exception e) {
                    handler.failed(e, attach);
                }
            }

            @Override
            public void failed(Throwable exc, A attach) {
                handler.failed(exc, attach);
            }
        });
    }

    @Override
    public <A> void read(final ByteBuffer[] dsts, final int offset, final int length, long timeout, TimeUnit unit, A attachment, final CompletionHandler<Long, ? super A> handler) {
        this.checkHandshake();
        if (handler == null) {
            throw CoyoteMessages.MESSAGES.nullHandler();
        }
        if (offset < 0 || length < 0 || offset > dsts.length - length) {
            throw new IndexOutOfBoundsException();
        }
        final ByteBuffer[] netInBuffers = new ByteBuffer[length];
        for (int i = 0; i < length; ++i) {
            netInBuffers[i] = ByteBuffer.allocate(this.getSSLSession().getPacketBufferSize());
        }
        this.reset(netInBuffers[0]);
        this.channel.read(netInBuffers, 0, length, timeout, unit, attachment, new CompletionHandler<Long, A>(){

            @Override
            public void completed(Long nBytes, A attach) {
                if (nBytes < 0L) {
                    this.failed(new ClosedChannelException(), attach);
                    return;
                }
                long read = 0L;
                for (int i = 0; i < length; ++i) {
                    try {
                        read += (long)SecureNioChannel.this.unwrap(netInBuffers[i], dsts[offset + i]);
                        continue;
                    }
                    catch (Exception e) {
                        handler.failed(e, attach);
                        return;
                    }
                }
                handler.completed(read, attach);
            }

            @Override
            public void failed(Throwable exc, A attach) {
                handler.failed(exc, attach);
            }
        });
    }

    @Override
    @Deprecated
    public Future<Integer> write(ByteBuffer src) {
        throw CoyoteMessages.MESSAGES.operationNotSupported();
    }

    @Override
    public int writeBytes(ByteBuffer src) throws Exception {
        return this.writeBytes(src, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public int writeBytes(ByteBuffer src, long timeout, TimeUnit unit) throws Exception {
        this.checkHandshake();
        this.netOutBuffer.compact();
        int written = this.wrap(src, this.netOutBuffer);
        this.netOutBuffer.flip();
        while (this.netOutBuffer.hasRemaining()) {
            int x = this.channel.write(this.netOutBuffer).get(timeout, unit);
            if (x >= 0) continue;
            throw new ClosedChannelException();
        }
        return written;
    }

    @Override
    public <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.write(src, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, attachment, handler);
    }

    @Override
    public <A> void write(final ByteBuffer src, final long timeout, final TimeUnit unit, final A attachment, final CompletionHandler<Integer, ? super A> handler) {
        this.checkHandshake();
        try {
            this.netOutBuffer.clear();
            final int written = this.wrap(src, this.netOutBuffer);
            this.netOutBuffer.flip();
            this.channel.write(this.netOutBuffer, timeout, unit, attachment, new CompletionHandler<Integer, A>(){

                @Override
                public void completed(Integer nBytes, A attach) {
                    if (nBytes < 0) {
                        this.failed(new EOFException(), attach);
                    } else if (SecureNioChannel.this.netOutBuffer.hasRemaining()) {
                        SecureNioChannel.this.channel.write(SecureNioChannel.this.netOutBuffer, timeout, unit, attachment, this);
                    } else if (written == 0) {
                        SecureNioChannel.this.write(src, timeout, unit, attachment, handler);
                    } else {
                        handler.completed(written, attach);
                    }
                }

                @Override
                public void failed(Throwable exc, A attach) {
                    handler.failed(exc, attach);
                }
            });
        }
        catch (Throwable exp) {
            handler.failed(exp, attachment);
        }
    }

    @Override
    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, final CompletionHandler<Long, ? super A> handler) {
        this.checkHandshake();
        if (handler == null) {
            throw CoyoteMessages.MESSAGES.nullHandler();
        }
        if (offset < 0 || length < 0 || offset > srcs.length - length) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer[] netOutBuffers = new ByteBuffer[length];
        int size = this.getSSLSession().getPacketBufferSize();
        long written = 0L;
        for (int i = 0; i < length; ++i) {
            try {
                netOutBuffers[i] = ByteBuffer.allocate(size);
                written += (long)this.wrap(srcs[offset + i], netOutBuffers[i]);
                netOutBuffers[i].flip();
                continue;
            }
            catch (Throwable exp) {
                handler.failed(exp, attachment);
                return;
            }
        }
        final long res = written;
        this.channel.write(netOutBuffers, 0, length, timeout, unit, attachment, new CompletionHandler<Long, A>(){

            @Override
            public void completed(Long nBytes, A attach) {
                if (nBytes < 0L) {
                    handler.failed(new ClosedChannelException(), attach);
                } else {
                    handler.completed(res, attach);
                }
            }

            @Override
            public void failed(Throwable exc, A attach) {
                handler.failed(exc, attach);
            }
        });
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.handleClose();
            this.channel.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void handleClose() throws Exception {
        if (this.sslEngine.isOutboundDone()) {
            return;
        }
        this.sslEngine.closeOutbound();
        SSLSession session = this.getSSLSession();
        int packetBufferSize = Math.max(session.getPacketBufferSize(), 16384);
        this.netOutBuffer = this.netOutBuffer == null ? ByteBuffer.allocate(packetBufferSize) : this.netOutBuffer.compact();
        ByteBuffer byteBuffer = this.netInBuffer = this.netInBuffer == null ? ByteBuffer.allocate(packetBufferSize) : this.netInBuffer.compact();
        while (!this.sslEngine.isOutboundDone()) {
            SSLEngineResult res = this.sslEngine.wrap(this.netInBuffer, this.netOutBuffer);
            switch (res.getStatus()) {
                case OK: {
                    this.tryTasks();
                    while (this.netOutBuffer.hasRemaining() && this.channel.write(this.netOutBuffer).get() >= 0) {
                        this.netOutBuffer.compact();
                    }
                    break;
                }
                case BUFFER_OVERFLOW: {
                    ByteBuffer tmp = ByteBuffer.allocate(packetBufferSize + this.netOutBuffer.capacity());
                    this.netOutBuffer.flip();
                    tmp.put(this.netOutBuffer);
                    this.netOutBuffer = tmp;
                    break;
                }
            }
        }
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    protected void setSslEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    private int wrap(ByteBuffer src, ByteBuffer dst) throws Exception {
        SSLEngineResult result = this.sslEngine.wrap(src, dst);
        int written = result.bytesConsumed();
        this.handshakeStatus = result.getHandshakeStatus();
        switch (result.getStatus()) {
            case OK: {
                this.tryTasks();
                break;
            }
            case CLOSED: {
                written = -1;
            }
            case BUFFER_OVERFLOW: {
                throw new BufferOverflowException();
            }
        }
        return written;
    }

    private int unwrap(ByteBuffer src, ByteBuffer dst) throws Exception {
        int read = 0;
        do {
            src.flip();
            SSLEngineResult result = this.sslEngine.unwrap(src, dst);
            src.compact();
            if (result.getStatus() == SSLEngineResult.Status.OK || result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                read += result.bytesProduced();
                this.handshakeStatus = result.getHandshakeStatus();
                this.tryTasks();
                if (result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                break;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && read > 0) break;
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                return -1;
            }
            throw new IOException(CoyoteMessages.MESSAGES.errorUnwrappingData(result.getStatus().toString()));
        } while (src.position() != 0);
        return read;
    }

    protected void handshake() throws SSLException {
        if (this.handshakeComplete) {
            return;
        }
        try {
            this.doHandshake();
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
    }

    private void checkHandshake() {
        if (!this.handshakeComplete) {
            throw CoyoteMessages.MESSAGES.incompleteHandshake();
        }
    }

    protected void reHandshake() throws SSLException {
        if (this.sslEngine.getWantClientAuth()) {
            CoyoteLogger.UTIL_LOGGER.debug("No client cert sent for want");
        } else if (!this.sslEngine.getNeedClientAuth()) {
            this.sslEngine.setNeedClientAuth(true);
        } else {
            CoyoteLogger.UTIL_LOGGER.debug("Already need client cert");
        }
        this.handshakeComplete = false;
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        try {
            this.doHandshake();
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
    }

    private void doHandshake() throws Exception {
        SSLSession session = this.getSSLSession();
        int packetBufferSize = Math.max(session.getPacketBufferSize(), 16384);
        this.initBuffers(packetBufferSize);
        ByteBuffer clientNetData = ByteBuffer.allocate(packetBufferSize);
        ByteBuffer clientAppData = ByteBuffer.allocate(packetBufferSize);
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        int i = 1;
        boolean read = true;
        block7: while (!this.handshakeComplete) {
            switch (this.handshakeStatus) {
                case NEED_UNWRAP: {
                    SSLEngineResult res;
                    int nBytes = 0;
                    if (read) {
                        clientAppData.clear();
                        nBytes = this.channel.read(this.netInBuffer).get();
                    }
                    if (nBytes < 0) {
                        throw new IOException(CoyoteMessages.MESSAGES.errorUnwrappingHandshake());
                    }
                    boolean cont = false;
                    do {
                        this.netInBuffer.flip();
                        res = this.sslEngine.unwrap(this.netInBuffer, clientAppData);
                        this.netInBuffer.compact();
                        this.handshakeStatus = res.getHandshakeStatus();
                        if (res.getStatus() == SSLEngineResult.Status.OK) {
                            this.tryTasks();
                            read = true;
                            continue;
                        }
                        if (res.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            read = true;
                            continue;
                        }
                        if (res.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                        ByteBuffer tmp = ByteBuffer.allocate(packetBufferSize * ++i);
                        if (clientAppData.position() > 0) {
                            clientAppData.flip();
                        }
                        tmp.put(clientAppData);
                        clientAppData = tmp;
                        read = false;
                    } while (cont = res.getStatus() == SSLEngineResult.Status.OK && this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                    break;
                }
                case NEED_WRAP: {
                    clientNetData.compact();
                    this.netOutBuffer.clear();
                    SSLEngineResult res = this.sslEngine.wrap(clientNetData, this.netOutBuffer);
                    this.handshakeStatus = res.getHandshakeStatus();
                    this.netOutBuffer.flip();
                    if (res.getStatus() == SSLEngineResult.Status.OK) {
                        this.tryTasks();
                        while (this.netOutBuffer.hasRemaining()) {
                            if (this.channel.write(this.netOutBuffer).get() >= 0) continue;
                            throw new IOException(CoyoteMessages.MESSAGES.errorWrappingHandshake());
                        }
                        continue block7;
                    }
                    throw new IOException(CoyoteMessages.MESSAGES.errorWrappingHandshakeStatus(res.getStatus().toString()));
                }
                case NEED_TASK: {
                    this.handshakeStatus = this.tasks();
                    break;
                }
                case NOT_HANDSHAKING: {
                    throw new SSLHandshakeException(CoyoteMessages.MESSAGES.notHandshaking());
                }
                case FINISHED: {
                    this.handshakeComplete = true;
                }
            }
        }
        this.handshakeComplete = this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private SSLEngineResult.HandshakeStatus tasks() {
        Runnable task = null;
        while ((task = this.sslEngine.getDelegatedTask()) != null) {
            task.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    private void tryTasks() {
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.handshakeStatus = this.tasks();
        }
    }

    private void initBuffers(int capacity) {
        if (this.netInBuffer == null) {
            this.netInBuffer = ByteBuffer.allocate(capacity);
        } else {
            this.netInBuffer.clear();
        }
        if (this.netOutBuffer == null) {
            this.netOutBuffer = ByteBuffer.allocate(capacity);
        } else {
            this.netOutBuffer.clear();
        }
    }

    protected boolean handshakeComplete() {
        return this.handshakeComplete;
    }

    public SSLSession getSSLSession() {
        return this.sslEngine.getSession();
    }
}

