/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.bayeux.request;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.apache.tomcat.bayeux.BayeuxException;
import org.apache.tomcat.bayeux.BayeuxRequest;
import org.apache.tomcat.bayeux.ClientImpl;
import org.apache.tomcat.bayeux.HttpError;
import org.apache.tomcat.bayeux.RequestBase;
import org.apache.tomcat.bayeux.TomcatBayeux;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.CoyoteMessages;

public class MetaHandshakeRequest
extends RequestBase
implements BayeuxRequest {
    protected static HashMap<String, Object> responseTemplate = new HashMap();

    public MetaHandshakeRequest(TomcatBayeux tomcatBayeux, HttpEvent event, JSONObject jsReq) throws JSONException {
        super(tomcatBayeux, event, jsReq);
    }

    public String getVersion() {
        return this.version;
    }

    public String getMinimumVersion() {
        return this.minVersion;
    }

    @Override
    public HttpError validate() {
        boolean error;
        boolean bl = error = this.version == null || this.version.length() == 0;
        if (!error) {
            boolean bl2 = error = this.suppConnTypesFlag == 0;
        }
        if (error) {
            return new HttpError(400, CoyoteMessages.MESSAGES.invalidBayeuxHandshake(), null);
        }
        return null;
    }

    @Override
    public int process(int prevops) throws BayeuxException {
        prevops = super.process(prevops);
        this.response = (HashMap)responseTemplate.clone();
        ClientImpl client = null;
        HttpError error = this.validate();
        if (error == null) {
            client = (ClientImpl)this.getTomcatBayeux().newClient("http-", null, false, this.getEvent());
            this.clientId = client.getId();
            client.setSupportedConnTypes(this.suppConnTypesFlag);
            client.setUseJsonFiltered(this.getExt().get("json-comment-filtered") != null);
            this.response.put("clientId", client.getId());
            ((HashMap)this.response.get("advice")).put("reconnect", "retry");
            ((HashMap)this.response.get("advice")).put("interval", this.getReconnectInterval());
        } else {
            this.response.put("successful", Boolean.FALSE);
            this.response.put("error", error.toString());
            client = TomcatBayeux.getErrorClient();
            ((HashMap)this.response.get("advice")).put("reconnect", "none");
        }
        try {
            JSONObject obj = new JSONObject(this.response);
            this.addToDeliveryQueue(client, obj);
        }
        catch (ServletException x) {
            throw new BayeuxException(x);
        }
        catch (IOException x) {
            throw new BayeuxException(x);
        }
        return 0;
    }

    static {
        responseTemplate.put("channel", "/meta/handshake");
        responseTemplate.put("version", "1.0");
        responseTemplate.put("supportedConnectionTypes", new String[]{"long-polling", "callback-polling"});
        responseTemplate.put("successful", Boolean.TRUE);
        responseTemplate.put("advice", new HashMap());
    }
}

