/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.Http11AprProcessor;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.res.StringManager;

public class InternalAprOutputBuffer
implements OutputBuffer {
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    protected Response response;
    protected MimeHeaders headers;
    protected boolean committed;
    protected boolean finished;
    protected byte[] buf;
    protected int pos;
    protected long socket;
    protected OutputBuffer outputStreamOutputBuffer;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected ByteBuffer bbuf = null;
    protected ByteChunk leftover = null;
    protected boolean nonBlocking = false;
    protected AprEndpoint endpoint = null;

    public InternalAprOutputBuffer(Response response, int headerBufferSize, AprEndpoint endpoint) {
        this.response = response;
        this.endpoint = endpoint;
        this.headers = response.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.bbuf = headerBufferSize < 8192 ? ByteBuffer.allocateDirect(9000) : ByteBuffer.allocateDirect((headerBufferSize / 1500 + 1) * 1500);
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        this.leftover = new ByteChunk();
        this.nonBlocking = false;
        HttpMessages.getMessage(200);
    }

    public void setSocket(long socket) {
        this.socket = socket;
        Socket.setsbb(this.socket, this.bbuf);
    }

    public long getSocket() {
        return this.socket;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    public boolean getNonBlocking() {
        return this.nonBlocking;
    }

    public void addFilter(OutputFilter filter) {
        OutputFilter[] newFilterLibrary = new OutputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void clearFilters() {
        this.filterLibrary = new OutputFilter[0];
        this.lastActiveFilter = -1;
    }

    public void addActiveFilter(OutputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.outputStreamOutputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setResponse(this.response);
    }

    public void flush() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        this.flushBuffer();
    }

    public void recycle() {
        this.response.recycle();
        this.bbuf.clear();
        this.socket = 0L;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
    }

    public void nextRequest() {
        this.response.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.leftover.recycle();
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        this.nonBlocking = false;
    }

    public void endRequest() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.flushBuffer();
        this.finished = true;
    }

    public void sendAck() throws IOException {
        if (!this.committed && Socket.send(this.socket, org.apache.coyote.http11.Constants.ACK_BYTES, 0, org.apache.coyote.http11.Constants.ACK_BYTES.length) < 0) {
            throw new IOException(sm.getString("oob.failedwrite"));
        }
    }

    public void sendStatus() {
        this.write(org.apache.coyote.http11.Constants.HTTP_11_BYTES);
        this.buf[this.pos++] = 32;
        int status = this.response.getStatus();
        switch (status) {
            case 200: {
                this.write(org.apache.coyote.http11.Constants._200_BYTES);
                break;
            }
            case 400: {
                this.write(org.apache.coyote.http11.Constants._400_BYTES);
                break;
            }
            case 404: {
                this.write(org.apache.coyote.http11.Constants._404_BYTES);
                break;
            }
            default: {
                this.write(status);
            }
        }
        this.buf[this.pos++] = 32;
        String message = null;
        if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER) {
            message = this.response.getMessage();
        }
        if (message == null) {
            this.write(HttpMessages.getMessage(status));
        } else {
            this.write(message.replace('\n', ' ').replace('\r', ' '));
        }
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void sendHeader(MessageBytes name, MessageBytes value) {
        if (name.getLength() > 0 && !value.isNull()) {
            this.write(name);
            this.buf[this.pos++] = 58;
            this.buf[this.pos++] = 32;
            this.write(value);
            this.buf[this.pos++] = 13;
            this.buf[this.pos++] = 10;
        }
    }

    public void sendHeader(ByteChunk name, ByteChunk value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void sendHeader(String name, String value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void endHeaders() {
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    @Override
    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.leftover.getLength() > 0 && Http11AprProcessor.containerThread.get() != Boolean.TRUE) {
            throw new IOException(sm.getString("oob.backlog"));
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(chunk, res);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(chunk, res);
    }

    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.bbuf.put(this.buf, 0, this.pos);
        }
    }

    protected void write(MessageBytes mb) {
        if (mb.getType() == 2) {
            ByteChunk bc = mb.getByteChunk();
            this.write(bc);
        } else if (mb.getType() == 3) {
            CharChunk cc = mb.getCharChunk();
            this.write(cc);
        } else {
            this.write(mb.toString());
        }
    }

    protected void write(ByteChunk bc) {
        int length = bc.getLength();
        System.arraycopy(bc.getBytes(), bc.getStart(), this.buf, this.pos, length);
        this.pos += length;
    }

    protected void write(CharChunk cc) {
        int start = cc.getStart();
        int end = cc.getEnd();
        char[] cbuf = cc.getBuffer();
        for (int i = start; i < end; ++i) {
            int c = cbuf[i];
            if (c <= 31 && c != 9) {
                c = 32;
            } else if (c == 127) {
                c = 32;
            }
            this.buf[this.pos++] = (byte)c;
        }
    }

    public void write(byte[] b) {
        System.arraycopy(b, 0, this.buf, this.pos, b.length);
        this.pos += b.length;
    }

    protected void write(String s) {
        if (s == null) {
            return;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c <= 31 && c != 9) {
                c = 32;
            } else if (c == 127) {
                c = 32;
            }
            this.buf[this.pos++] = (byte)c;
        }
    }

    protected void write(int i) {
        this.write(String.valueOf(i));
    }

    public boolean flushLeftover() throws IOException {
        int len = this.leftover.getLength();
        int start = this.leftover.getStart();
        byte[] b = this.leftover.getBuffer();
        while (len > 0) {
            int thisTime = len;
            if (this.bbuf.position() == this.bbuf.capacity()) {
                int pos;
                int end = this.bbuf.position();
                int res = 0;
                for (pos = 0; pos < end && (res = Socket.sendibb(this.socket, pos, end - pos)) > 0; pos += res) {
                }
                if (res < 0) {
                    throw new IOException(sm.getString("oob.failedwrite"));
                }
                this.response.setLastWrite(res);
                if (pos < end) {
                    this.leftover.setOffset(start);
                    this.bbuf.position(pos);
                    return false;
                }
                this.bbuf.clear();
            }
            if (thisTime > this.bbuf.capacity() - this.bbuf.position()) {
                thisTime = this.bbuf.capacity() - this.bbuf.position();
            }
            this.bbuf.put(b, start, thisTime);
            len -= thisTime;
            start += thisTime;
        }
        int pos = 0;
        int end = this.bbuf.position();
        if (pos < end) {
            int res = 0;
            while (pos < end && (res = Socket.sendibb(this.socket, pos, end - pos)) > 0) {
                pos += res;
            }
            if (res < 0) {
                throw new IOException(sm.getString("oob.failedwrite"));
            }
            this.response.setLastWrite(res);
        }
        if (pos < end) {
            this.leftover.allocate(end - pos, -1);
            this.bbuf.position(pos);
            this.bbuf.limit(end);
            this.bbuf.get(this.leftover.getBuffer(), 0, end - pos);
            this.leftover.setEnd(end - pos);
            this.bbuf.clear();
            return false;
        }
        this.bbuf.clear();
        this.leftover.recycle();
        return true;
    }

    protected void flushBuffer() throws IOException {
        int res = 0;
        if (this.leftover.getLength() > 0) {
            if (Http11AprProcessor.containerThread.get() == Boolean.TRUE) {
                Socket.timeoutSet(this.socket, this.endpoint.getSoTimeout() * 1000);
                res = Socket.send(this.socket, this.leftover.getBuffer(), this.leftover.getOffset(), this.leftover.getEnd());
                this.leftover.recycle();
                if (res > 0 && this.bbuf.position() > 0) {
                    res = Socket.sendbb(this.socket, 0, this.bbuf.position());
                }
                this.bbuf.clear();
                Socket.timeoutSet(this.socket, 0L);
            } else {
                throw new IOException(sm.getString("oob.backlog"));
            }
        }
        if (this.bbuf.position() > 0) {
            if (this.nonBlocking) {
                int pos;
                int end = this.bbuf.position();
                for (pos = 0; pos < end && (res = Socket.sendibb(this.socket, pos, end - pos)) > 0; pos += res) {
                }
                if (pos < end) {
                    if (this.response.getFlushLeftovers() && Http11AprProcessor.containerThread.get() == Boolean.TRUE) {
                        Socket.timeoutSet(this.socket, this.endpoint.getSoTimeout() * 1000);
                        res = Socket.sendbb(this.socket, 0, end);
                        Socket.timeoutSet(this.socket, 0L);
                    } else {
                        this.leftover.allocate(end - pos, -1);
                        this.bbuf.position(pos);
                        this.bbuf.limit(end);
                        this.bbuf.get(this.leftover.getBuffer(), 0, end - pos);
                        this.leftover.setEnd(end - pos);
                        if (!this.response.getFlushLeftovers()) {
                            this.response.action(ActionCode.ACTION_EVENT_WRITE, null);
                        }
                    }
                }
            } else {
                res = Socket.sendbb(this.socket, 0, this.bbuf.position());
            }
            this.response.setLastWrite(res);
            this.bbuf.clear();
            if (res < 0) {
                throw new IOException(sm.getString("oob.failedwrite"));
            }
        }
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            if (InternalAprOutputBuffer.this.leftover.getLength() > 0) {
                InternalAprOutputBuffer.this.leftover.append(chunk);
                return chunk.getLength();
            }
            int len = chunk.getLength();
            int start = chunk.getStart();
            byte[] b = chunk.getBuffer();
            while (len > 0) {
                int thisTime = len;
                if (InternalAprOutputBuffer.this.bbuf.position() == InternalAprOutputBuffer.this.bbuf.capacity()) {
                    InternalAprOutputBuffer.this.flushBuffer();
                    if (InternalAprOutputBuffer.this.leftover.getLength() > 0) {
                        int oldStart = chunk.getOffset();
                        chunk.setOffset(start);
                        InternalAprOutputBuffer.this.leftover.append(chunk);
                        chunk.setOffset(oldStart);
                        return chunk.getLength();
                    }
                }
                if (thisTime > InternalAprOutputBuffer.this.bbuf.capacity() - InternalAprOutputBuffer.this.bbuf.position()) {
                    thisTime = InternalAprOutputBuffer.this.bbuf.capacity() - InternalAprOutputBuffer.this.bbuf.position();
                }
                InternalAprOutputBuffer.this.bbuf.put(b, start, thisTime);
                len -= thisTime;
                start += thisTime;
            }
            return chunk.getLength();
        }
    }
}

