/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileSystem;

public class ShrinkWrapPath
implements Path {
    private static final Logger log = Logger.getLogger(ShrinkWrapPath.class.getName());
    private static final String DIR_BACK = "..";
    private static final String DIR_THIS = ".";
    private final String path;
    private final ShrinkWrapFileSystem fileSystem;

    ShrinkWrapPath(String path, ShrinkWrapFileSystem fileSystem) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("path must be specified");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("File system must be specified.");
        }
        this.path = path;
        this.fileSystem = fileSystem;
    }

    ShrinkWrapPath(ArchivePath path, ShrinkWrapFileSystem fileSystem) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException(ArchivePath.class.getSimpleName() + " must be specified");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("File system must be specified.");
        }
        this.path = path.get();
        this.fileSystem = fileSystem;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.path.startsWith(ArchivePath.SEPARATOR_STRING);
    }

    @Override
    public Path getRoot() {
        return this.isAbsolute() ? new ShrinkWrapPath(ArchivePaths.root(), this.fileSystem) : null;
    }

    @Override
    public Path getFileName() {
        if (this.path.isEmpty() || this.path.equals(ArchivePaths.root().get())) {
            return null;
        }
        List<String> tokens = ShrinkWrapPath.tokenize(this);
        ShrinkWrapPath fileName = new ShrinkWrapPath(tokens.get(tokens.size() - 1), this.fileSystem);
        return fileName;
    }

    @Override
    public Path getParent() {
        List<String> tokens = ShrinkWrapPath.tokenize(this);
        int numTokens = tokens.size();
        if (numTokens == 0 || numTokens == 1 && !this.isAbsolute()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (this.isAbsolute()) {
            sb.append('/');
        }
        for (int i = 0; i < numTokens - 1; ++i) {
            if (i >= 1) {
                sb.append('/');
            }
            sb.append(tokens.get(i));
        }
        String parentPath = sb.toString();
        return new ShrinkWrapPath(parentPath, this.fileSystem);
    }

    @Override
    public int getNameCount() {
        String context = this.path;
        if (context.endsWith(ArchivePath.SEPARATOR_STRING)) {
            context = context.substring(0, context.length() - 1);
        }
        if (context.startsWith(ArchivePath.SEPARATOR_STRING)) {
            context = context.substring(1);
        }
        if (context.isEmpty()) {
            return 0;
        }
        int pathSeparators = this.countOccurrences(context, '/', 0);
        return pathSeparators + 1;
    }

    private int countOccurrences(String string, char c, int offset) {
        assert (string != null) : "String must be specified";
        return (offset = string.indexOf(c, offset)) == -1 ? 0 : 1 + this.countOccurrences(string, c, offset + 1);
    }

    @Override
    public Path getName(int index) {
        Path subpath = this.subpath(0, index + 1);
        return subpath;
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("Begin index must be greater than 0");
        }
        if (endIndex < 0) {
            throw new IllegalArgumentException("End index must be greater than 0");
        }
        if (endIndex <= beginIndex) {
            throw new IllegalArgumentException("End index must be greater than begin index");
        }
        List<String> tokens = ShrinkWrapPath.tokenize(this);
        int tokenCount = tokens.size();
        if (beginIndex >= tokenCount) {
            throw new IllegalArgumentException("Invalid begin index " + endIndex + " for " + this + "; must be between 0 and " + tokenCount + " exclusive");
        }
        if (endIndex > tokenCount) {
            throw new IllegalArgumentException("Invalid end index " + endIndex + " for " + this + "; must be between 0 and " + tokenCount + " inclusive");
        }
        StringBuilder newPathBuilder = new StringBuilder();
        for (int i = 0; i < endIndex; ++i) {
            newPathBuilder.append('/');
            newPathBuilder.append(tokens.get(i));
        }
        Path newPath = this.fromString(newPathBuilder.toString());
        return newPath;
    }

    @Override
    public boolean startsWith(Path other) {
        if (other == null) {
            throw new IllegalArgumentException("other path must be specified");
        }
        if (this.getFileSystem() != other.getFileSystem()) {
            return false;
        }
        List<String> ourTokens = ShrinkWrapPath.tokenize(this);
        List<String> otherTokens = ShrinkWrapPath.tokenize((ShrinkWrapPath)other);
        if (other.isAbsolute() && !this.isAbsolute()) {
            return false;
        }
        int otherTokensSize = otherTokens.size();
        if (otherTokensSize > ourTokens.size()) {
            return false;
        }
        for (int i = 0; i < otherTokensSize; ++i) {
            if (otherTokens.get(i).equals(ourTokens.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String other) {
        if (other == null) {
            throw new IllegalArgumentException("other path input must be specified");
        }
        Path otherPath = this.fromString(other);
        return this.startsWith(otherPath);
    }

    @Override
    public boolean endsWith(Path other) {
        if (other == null) {
            throw new IllegalArgumentException("other path must be specified");
        }
        if (this.getFileSystem() != other.getFileSystem()) {
            return false;
        }
        List<String> ourTokens = ShrinkWrapPath.tokenize(this);
        List<String> otherTokens = ShrinkWrapPath.tokenize((ShrinkWrapPath)other);
        int numOtherTokens = otherTokens.size();
        if (numOtherTokens > ourTokens.size()) {
            return false;
        }
        int differential = ourTokens.size() - numOtherTokens;
        if (other.isAbsolute() && differential != 0) {
            return false;
        }
        for (int i = numOtherTokens - 1; i >= 0; --i) {
            if (ourTokens.get(i + differential).equals(otherTokens.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) {
        if (other == null) {
            throw new IllegalArgumentException("other path input must be specified");
        }
        Path otherPath = this.fromString(other);
        return this.endsWith(otherPath);
    }

    @Override
    public Path normalize() {
        String normalizedString = ShrinkWrapPath.normalize(ShrinkWrapPath.tokenize(this), this.isAbsolute());
        ShrinkWrapPath normalized = new ShrinkWrapPath(normalizedString, this.fileSystem);
        return normalized;
    }

    @Override
    public Path resolve(Path other) {
        if (other == null) {
            throw new IllegalArgumentException("other path must be specified");
        }
        if (other.isAbsolute()) {
            return other;
        }
        if (other.toString().isEmpty()) {
            return this;
        }
        StringBuilder sb = new StringBuilder(this.path);
        if (!this.path.endsWith(ArchivePath.SEPARATOR_STRING)) {
            sb.append('/');
        }
        sb.append(other);
        ShrinkWrapPath newPath = new ShrinkWrapPath(sb.toString(), this.fileSystem);
        return newPath;
    }

    @Override
    public Path resolve(String other) {
        Path otherPath = this.fromString(other);
        return this.resolve(otherPath);
    }

    @Override
    public Path resolveSibling(Path other) {
        if (other == null) {
            throw new IllegalArgumentException("other path must be specified");
        }
        return other;
    }

    @Override
    public Path resolveSibling(String other) {
        Path otherPath = this.fromString(other);
        return this.resolveSibling(otherPath);
    }

    @Override
    public Path relativize(Path other) {
        if (other == null) {
            throw new IllegalArgumentException("other path must be specified");
        }
        if (!(other instanceof ShrinkWrapPath)) {
            throw new IllegalArgumentException("Can only relativize paths of type " + ShrinkWrapPath.class.getSimpleName());
        }
        if (this.equals(other)) {
            return new ShrinkWrapPath("", this.fileSystem);
        }
        ShrinkWrapPath newPath = ShrinkWrapPath.relativizeCommonRoot(this, this, other, other, 0);
        return newPath;
    }

    @Override
    public URI toUri() {
        URI root = ShrinkWrapFileSystems.getRootUri(this.fileSystem.getArchive());
        String location = root + this.toString().substring(1);
        URI uri = URI.create(location);
        return uri;
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        ShrinkWrapPath absolutePath = new ShrinkWrapPath('/' + this.path, this.fileSystem);
        Path normalized = absolutePath.normalize();
        return normalized;
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        if (!this.fileSystem.getArchive().contains(this.path)) {
            throw new FileNotFoundException("Path points to a nonexistent file or directory: " + this);
        }
        return this;
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("This path is associated with a ShrinkWrap archive, not the default provider");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        throw new UnsupportedOperationException("ShrinkWrap Paths do not support registration with a watch service.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) {
        return this.register(watcher, events, new WatchEvent.Modifier[]{null});
    }

    @Override
    public Iterator<Path> iterator() {
        List<String> tokens = ShrinkWrapPath.tokenize(this);
        int tokensSize = tokens.size();
        ArrayList<ShrinkWrapPath> paths = new ArrayList<ShrinkWrapPath>(tokensSize);
        for (int i = 0; i < tokensSize; ++i) {
            ArchivePath newPath = ArchivePaths.root();
            for (int j = 0; j <= i; ++j) {
                newPath = ArchivePaths.create((ArchivePath)newPath, (String)tokens.get(j));
            }
            paths.add(new ShrinkWrapPath(newPath, this.fileSystem));
        }
        return paths.iterator();
    }

    @Override
    public int compareTo(Path other) {
        if (other == null) {
            throw new IllegalArgumentException("other path must be specified");
        }
        return this.toString().compareTo(other.toString());
    }

    @Override
    public String toString() {
        return this.path;
    }

    private Path fromString(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path must be specified");
        }
        return new ShrinkWrapPath(path, this.fileSystem);
    }

    private static List<String> tokenize(ShrinkWrapPath path) {
        StringTokenizer tokenizer = new StringTokenizer(path.toString(), ArchivePath.SEPARATOR_STRING);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    private static String normalize(List<String> path, boolean absolute) {
        int indexDirBack;
        assert (path != null) : "path must be specified";
        if (path.contains(DIR_THIS)) {
            path.remove(DIR_THIS);
            ShrinkWrapPath.normalize(path, absolute);
        }
        if ((indexDirBack = path.indexOf(DIR_BACK)) != -1) {
            if (indexDirBack > 0) {
                path.remove(indexDirBack);
                path.remove(indexDirBack - 1);
                ShrinkWrapPath.normalize(path, absolute);
            } else {
                throw new IllegalArgumentException("Cannot specify to go back \"../\" past the root");
            }
        }
        StringBuilder sb = new StringBuilder();
        if (absolute) {
            sb.append('/');
        }
        for (int i = 0; i < path.size(); ++i) {
            if (i > 0) {
                sb.append('/');
            }
            sb.append(path.get(i));
        }
        return sb.toString();
    }

    private static ShrinkWrapPath relativizeCommonRoot(ShrinkWrapPath thisOriginal, Path thisCurrent, Path otherOriginal, Path otherCurrent, int backupCount) {
        assert (thisOriginal != null);
        assert (thisCurrent != null);
        assert (otherOriginal != null);
        assert (otherCurrent != null);
        assert (backupCount >= 0);
        if (!otherCurrent.startsWith(thisCurrent)) {
            Path otherParent = otherCurrent.getParent();
            ShrinkWrapPath thisParent = (ShrinkWrapPath)thisCurrent.getParent();
            if (otherParent != null && thisParent != null) {
                return ShrinkWrapPath.relativizeCommonRoot(thisOriginal, thisParent, otherOriginal, otherParent, backupCount + 1);
            }
            throw new IllegalArgumentException("No common components");
        }
        List<String> thisTokens = ShrinkWrapPath.tokenize(thisOriginal);
        List<String> otherTokens = ShrinkWrapPath.tokenize((ShrinkWrapPath)otherOriginal);
        int numOtherTokens = otherTokens.size();
        int numToTake = otherTokens.size() - thisTokens.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < backupCount; ++i) {
            sb.append(DIR_BACK);
            sb.append('/');
        }
        int startCounter = numOtherTokens - numToTake - backupCount;
        int stopCounter = numOtherTokens - 1;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Backup: " + backupCount);
            log.finest("This tokens: " + thisTokens);
            log.finest("Other tokens: " + otherTokens);
            log.finest("Differential: " + numToTake);
            log.finest("Start: " + startCounter);
            log.finest("Stop: " + stopCounter);
        }
        for (int i = startCounter; i <= stopCounter; ++i) {
            if (i > startCounter) {
                sb.append('/');
            }
            sb.append(otherTokens.get(i));
        }
        return new ShrinkWrapPath(sb.toString(), thisOriginal.fileSystem);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileSystem == null ? 0 : this.fileSystem.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShrinkWrapPath other = (ShrinkWrapPath)obj;
        if (this.fileSystem != other.fileSystem) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

