/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.impl.base.Validate;

public class ZipFileEntryAsset
implements Asset {
    private final File file;
    private final ZipEntry entry;

    public ZipFileEntryAsset(File file, ZipEntry entry) {
        Validate.notNull(file, "File must be specified");
        Validate.notNull(entry, "Entry must be specified");
        this.file = file;
        this.entry = entry;
    }

    public InputStream openStream() {
        try {
            ZipFile file = new ZipFile(this.file);
            return new InputStreamWrapper(file, file.getInputStream(this.entry));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not open zip file stream", e);
        }
    }

    private static class InputStreamWrapper
    extends InputStream {
        private final ZipFile file;
        private final InputStream is;

        private InputStreamWrapper(ZipFile file, InputStream is) {
            this.file = file;
            this.is = is;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public void close() throws IOException {
            try {
                try {
                    this.is.close();
                }
                finally {
                    this.file.close();
                }
            }
            finally {
                super.close();
            }
        }
    }
}

