/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.io.tar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.shrinkwrap.impl.base.io.tar.TarEntry;
import org.jboss.shrinkwrap.impl.base.io.tar.TarOutputStreamImpl;

public class TarOutputStream
extends TarOutputStreamImpl {
    private TarOutputStreamImpl tos = null;
    private ByteArrayOutputStream bos = null;
    private TarEntry currentEntry = null;

    public TarOutputStream(OutputStream out) throws IOException {
        super(null);
        this.tos = new TarOutputStreamImpl(out);
        this.bos = new ByteArrayOutputStream();
    }

    @Override
    public void setDebug(boolean b) {
        this.tos.setDebug(b);
    }

    @Override
    public void setBufferDebug(boolean b) {
        this.tos.setBufferDebug(b);
    }

    @Override
    public void finish() throws IOException {
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        this.tos.finish();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.tos.close();
    }

    @Override
    public int getRecordSize() {
        return this.tos.getRecordSize();
    }

    @Override
    public void putNextEntry(TarEntry entry) throws IOException {
        if (entry.getSize() != 0L) {
            this.tos.putNextEntry(entry);
        } else {
            this.currentEntry = entry;
        }
    }

    @Override
    public void closeEntry() throws IOException {
        if (this.currentEntry == null) {
            this.tos.closeEntry();
        } else {
            this.currentEntry.setSize(this.bos.size());
            this.tos.putNextEntry(this.currentEntry);
            this.bos.writeTo(this.tos);
            this.tos.closeEntry();
            this.currentEntry = null;
            this.bos = new ByteArrayOutputStream();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.currentEntry == null) {
            this.tos.write(b);
        } else {
            this.bos.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.currentEntry == null) {
            this.tos.write(b);
        } else {
            this.bos.write(b);
        }
    }

    @Override
    public void write(byte[] b, int start, int length) throws IOException {
        if (this.currentEntry == null) {
            this.tos.write(b, start, length);
        } else {
            this.bos.write(b, start, length);
        }
    }

    @Override
    public void flush() throws IOException {
        this.bos.flush();
    }
}

