/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import java.util.Collection;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ClassLoaderSearchUtil;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.SecurityActions;
import org.jboss.shrinkwrap.api.ShrinkWrap;

public final class Filters {
    private static final String IMPL_CLASS_NAME_INCLUDE_ALL_PATHS = "org.jboss.shrinkwrap.impl.base.filter.IncludeAllPaths";
    private static final String IMPL_CLASS_NAME_INCLUDE_REGEXP_PATHS = "org.jboss.shrinkwrap.impl.base.filter.IncludeRegExpPaths";
    private static final String IMPL_CLASS_NAME_EXCLUDE_REGEXP_PATHS = "org.jboss.shrinkwrap.impl.base.filter.ExcludeRegExpPaths";
    private static final String IMPL_CLASS_NAME_INCLUDE_PATHS = "org.jboss.shrinkwrap.impl.base.filter.IncludePaths";
    private static final String IMPL_CLASS_NAME_EXCLUDE_PATHS = "org.jboss.shrinkwrap.impl.base.filter.ExcludePaths";

    public static Filter<ArchivePath> includeAll() {
        return Filters.getFilterInstance(IMPL_CLASS_NAME_INCLUDE_ALL_PATHS, new Class[0], new Object[0]);
    }

    public static Filter<ArchivePath> include(String regexp) {
        return Filters.getFilterInstance(IMPL_CLASS_NAME_INCLUDE_REGEXP_PATHS, new Class[]{String.class}, new Object[]{regexp});
    }

    public static Filter<ArchivePath> exclude(String regexp) {
        return Filters.getFilterInstance(IMPL_CLASS_NAME_EXCLUDE_REGEXP_PATHS, new Class[]{String.class}, new Object[]{regexp});
    }

    public static Filter<ArchivePath> includePaths(String ... paths) {
        return Filters.getFilterInstance(IMPL_CLASS_NAME_INCLUDE_PATHS, new Class[]{String[].class}, new Object[]{paths});
    }

    public static Filter<ArchivePath> includePaths(Collection<String> paths) {
        return Filters.getFilterInstance(IMPL_CLASS_NAME_INCLUDE_PATHS, new Class[]{Collection.class}, new Object[]{paths});
    }

    public static Filter<ArchivePath> excludePaths(String ... paths) {
        return Filters.getFilterInstance(IMPL_CLASS_NAME_EXCLUDE_PATHS, new Class[]{String[].class}, new Object[]{paths});
    }

    public static Filter<ArchivePath> excludePaths(Collection<String> paths) {
        return Filters.getFilterInstance(IMPL_CLASS_NAME_EXCLUDE_PATHS, new Class[]{Collection.class}, new Object[]{paths});
    }

    public static Filter<ArchivePath> exclude(Package ... packages) {
        return Filters.createRegExpFilter(IMPL_CLASS_NAME_EXCLUDE_REGEXP_PATHS, packages);
    }

    public static Filter<ArchivePath> include(Package ... packages) {
        return Filters.createRegExpFilter(IMPL_CLASS_NAME_INCLUDE_REGEXP_PATHS, packages);
    }

    private static Filter<ArchivePath> createRegExpFilter(String filterClassName, Package ... packages) {
        StringBuilder classExpression = new StringBuilder();
        for (Package pack : packages) {
            classExpression.append("|");
            classExpression.append("(.*" + pack.getName().replaceAll("\\.", "\\.") + ".*)");
        }
        classExpression.deleteCharAt(0);
        return Filters.getFilterInstance(filterClassName, new Class[]{String.class}, new Object[]{classExpression.toString()});
    }

    public static Filter<ArchivePath> include(Class<?> ... classes) {
        return Filters.createRegExpFilter(IMPL_CLASS_NAME_INCLUDE_REGEXP_PATHS, classes);
    }

    public static Filter<ArchivePath> exclude(Class<?> ... classes) {
        return Filters.createRegExpFilter(IMPL_CLASS_NAME_EXCLUDE_REGEXP_PATHS, classes);
    }

    private static Filter<ArchivePath> createRegExpFilter(String regExpFilterImplName, Class<?> ... classes) {
        StringBuilder classExpression = new StringBuilder();
        for (Class<?> clazz : classes) {
            classExpression.append("|");
            classExpression.append("(.*" + clazz.getName().replaceAll("\\.", "\\.") + "\\.class)");
        }
        classExpression.deleteCharAt(0);
        return Filters.getFilterInstance(regExpFilterImplName, new Class[]{String.class}, new Object[]{classExpression.toString()});
    }

    private static Filter<ArchivePath> getFilterInstance(String filterClassName, Class<?>[] ctorTypes, Object[] ctorArguments) {
        Class<?> filterClass;
        assert (filterClassName != null && !filterClassName.isEmpty()) : "Filter class name must be specified";
        assert (ctorTypes != null) : "Construction types must be specified";
        assert (ctorArguments != null) : "Construction arguments must be specified";
        assert (ctorTypes.length == ctorArguments.length) : "The number of ctor arguments and their types must match";
        try {
            filterClass = ClassLoaderSearchUtil.findClassFromClassLoaders(filterClassName, ShrinkWrap.getDefaultDomain().getConfiguration().getClassLoaders());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Could not find filter implementation class " + filterClassName + " in any of the configured CLs", cnfe);
        }
        return SecurityActions.newInstance(filterClass, ctorTypes, ctorArguments, Filter.class);
    }

    private Filters() {
    }
}

