/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.bootstrap;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;

class MavenResolutionFilterWrap
implements DependencyFilter {
    private static final Logger log = Logger.getLogger(MavenResolutionFilterWrap.class.getName());
    private final MavenResolutionFilter[] filters;
    private final List<MavenDependency> dependenciesForResolution;

    MavenResolutionFilterWrap(MavenResolutionFilter[] filters, List<MavenDependency> dependenciesForResolution) {
        assert (filters != null) : "filters must be specified, even if empty";
        assert (dependenciesForResolution != null) : "declaredDependencies must be specified";
        this.dependenciesForResolution = dependenciesForResolution;
        this.filters = filters;
    }

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return false;
        }
        ArrayList<MavenDependency> ancestors = new ArrayList<MavenDependency>();
        for (DependencyNode parent : parents) {
            Dependency parentDependency = parent.getDependency();
            if (parentDependency == null) continue;
            ancestors.add(MavenConverter.fromDependency(parentDependency));
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Filtering {0} using {1} filters", new Object[]{dependency, this.filters.length});
        }
        for (MavenResolutionFilter filter : this.filters) {
            if (filter.accepts(MavenConverter.fromDependency(dependency), this.dependenciesForResolution, ancestors)) continue;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Dependency {0} rejected by {1}", new Object[]{dependency, filter});
            }
            return false;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Dependency {0} was accepted.", dependency);
        }
        return true;
    }
}

