/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IOUtil {
    private static final Logger log = Logger.getLogger(IOUtil.class.getName());

    private IOUtil() {
        throw new UnsupportedOperationException("No instances should be created; stateless class");
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int read = 0;
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
        }
        output.flush();
    }

    public static void copyWithClose(InputStream input, OutputStream output) throws IOException {
        try {
            IOUtil.copy(input, output);
        }
        finally {
            block13: {
                block12: {
                    try {
                        input.close();
                    }
                    catch (IOException ignore) {
                        if (!log.isLoggable(Level.FINER)) break block12;
                        log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                    }
                }
                try {
                    output.close();
                }
                catch (IOException ignore) {
                    if (!log.isLoggable(Level.FINER)) break block13;
                    log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                }
            }
        }
    }
}

