/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.github;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.AphroditeConfig;
import org.jboss.set.aphrodite.domain.Compare;
import org.jboss.set.aphrodite.domain.spi.CompareHome;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;
import org.jboss.set.aphrodite.repository.services.common.RepositoryUtils;
import org.jboss.set.aphrodite.repository.services.github.AbstractGithubService;
import org.jboss.set.aphrodite.repository.services.github.GitHubWrapper;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTag;

public class GithubCompareHomeService
extends AbstractGithubService
implements CompareHome {
    private static final Log LOG = LogFactory.getLog(GithubCompareHomeService.class);
    private static final GitHubWrapper WRAPPER = new GitHubWrapper();

    public GithubCompareHomeService(Aphrodite aphrodite) {
        super(RepositoryType.GITHUB);
        AphroditeConfig configuration = aphrodite.getConfig();
        this.init(configuration);
    }

    public Compare getCompare(URL url, String tag1, String tag2) {
        try {
            return WRAPPER.toCompare(github.getRepository(RepositoryUtils.createRepositoryIdFromUrl((URL)url)).getCompare(tag1, tag2));
        }
        catch (IOException e) {
            Utils.logWarnMessage((Log)LOG, (String)("repository : " + url + " is not accessable due to " + e.getMessage() + ". Check repository link and your account permission."));
            return new Compare();
        }
    }

    public List<String> getTags(URL url) {
        try {
            GHRepository repo = github.getRepository(RepositoryUtils.createRepositoryIdFromUrl((URL)url));
            return repo.listTags().toList().stream().map(GHTag::getName).collect(Collectors.toList());
        }
        catch (IOException e) {
            Utils.logWarnMessage((Log)LOG, (String)("repository : " + url + " is not accessable due to " + e.getMessage() + ". Check repository link and your account permission."));
            return Collections.EMPTY_LIST;
        }
    }

    public List<String> getBranches(URL url) {
        try {
            GHRepository repo = github.getRepository(RepositoryUtils.createRepositoryIdFromUrl((URL)url));
            return new ArrayList<String>(repo.getBranches().keySet());
        }
        catch (IOException e) {
            Utils.logWarnMessage((Log)LOG, (String)("repository : " + url + " is not accessable due to " + e.getMessage() + ". Check repository link and your account permission."));
            return Collections.EMPTY_LIST;
        }
    }

    protected Log getLog() {
        return LOG;
    }
}

