/*
 * Copyright © 2008  Red Hat Middleware, LLC. or third-party contributors as indicated 
 * by the @author tags or express copyright attribution statements applied by the 
 * authors. All third-party contributions are distributed under license by Red Hat 
 * Middleware LLC.
 *
 * This copyrighted material is made available to anyone wishing to use, modify, copy, 
 * or redistribute it subject to the terms and conditions of the GNU Lesser General 
 * Public License, v. 2.1. This program is distributed in the hope that it will be 
 * useful, but WITHOUT A WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for 
 * more details. You should have received a copy of the GNU Lesser General Public License, 
 * v.2.1 along with this distribution; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

package org.jboss.security.negotiation.spnego.encoding;

import org.jboss.security.negotiation.NegotiationMessage;

/**
 * The common base type for all SPNEGO messages.
 * 
 * @author darran.lofthouse@jboss.com
 * @since 17th August 2008
 * @version $Revision$
 */
public abstract class SPNEGOMessage extends NegotiationMessage
{

   private byte[] mechListMIC = null;

   @Override
   public String getMessageType()
   {
      return "SPNEGO";
   }

   public byte[] getMechListMIC()
   {
      return mechListMIC;
   }

   public void setMechListMIC(byte[] mechListMIC)
   {
      this.mechListMIC = mechListMIC;
   }

}
