/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.plugins.visitor;

import java.util.*;

import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.reflect.spi.TypeInfo;

/**
 * Cache type info directly.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class CachingReflectProvider implements ReflectProvider
{
   private ReflectProvider delegate;
   private volatile Map<ResourceContext, TypeInfo> cache = new HashMap<ResourceContext, TypeInfo>();

   public CachingReflectProvider(ReflectProvider delegate)
   {
      if (delegate == null)
         throw new IllegalArgumentException("Null delegate");
      this.delegate = delegate;
   }

   public TypeInfo getTypeInfo(ResourceContext resource) throws Throwable
   {
      TypeInfo result = cache.get(resource);
      if (result == null)
      {
         result = delegate.getTypeInfo(resource);
         cache.put(resource, result);
      }
      return result;
   }

   public void reset()
   {
      Map<ResourceContext, TypeInfo> tmp = cache;
      // dummy cache, go to delegate from now on
      cache = new AbstractMap<ResourceContext, TypeInfo>()
      {
         @Override
         public Set<Entry<ResourceContext, TypeInfo>> entrySet()
         {
            return Collections.emptySet();
         }

         @Override
         public TypeInfo put(ResourceContext key, TypeInfo value)
         {
            return null;
         }
      };
      tmp.clear();
   }
}