/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.plugins.helpers;

import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.scanning.plugins.visitor.ConfiguratorReflectProvider;
import org.jboss.scanning.plugins.visitor.ReflectProvider;

/**
 * Reflect provider factory.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class ReflectProviderUtilFactory implements UtilFactory<ReflectProvider>
{
   public ReflectProvider create(DeploymentUnit unit)
   {
      DeploymentUnit top = unit.getTopLevel();
      ControllerContext context = top.getAttachment(ControllerContext.class);
      if (context == null)
         throw new IllegalArgumentException("Not a kernel bound deployment unit: " + unit);

      Controller controller = context.getController();
      if (controller instanceof KernelController == false)
         throw new IllegalArgumentException("Not a kernel controller: " + controller);

      KernelController kc = (KernelController) controller;
      Kernel kernel = kc.getKernel();
      KernelConfigurator configurator = kernel.getConfigurator();
      return new ConfiguratorReflectProvider(configurator);
   }
}