/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.plugins.helpers;

import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;

import org.jboss.classloading.spi.visitor.ResourceContext;

/**
 * Direct class source location finder.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class ClassResourceOwnerFinder implements ResourceOwnerFinder
{
   public static ResourceOwnerFinder INSTANCE = new ClassResourceOwnerFinder();
   
   private ClassResourceOwnerFinder()
   {
   }

   /**
    * This one loads the class.
    *
    * @param resource the resource
    * @return the owner url
    */
   public URL findOwnerURL(ResourceContext resource)
   {
      if (resource.isClass() == false)
         throw new IllegalArgumentException("Can only handle classes: " + resource);

      Class<?> clazz = resource.loadClass();
      ProtectionDomain domain = clazz.getProtectionDomain();
      CodeSource source = domain.getCodeSource();
      return source.getLocation();
   }
}