/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.wadl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.wadl.ResteasyWadlMethodMetaData;
import org.jboss.resteasy.wadl.ResteasyWadlMethodParamMetaData;
import org.jboss.resteasy.wadl.ResteasyWadlResourceMetaData;
import org.jboss.resteasy.wadl.ResteasyWadlServiceRegistry;
import org.jboss.resteasy.wadl.jaxb.Application;
import org.jboss.resteasy.wadl.jaxb.Method;
import org.jboss.resteasy.wadl.jaxb.ObjectFactory;
import org.jboss.resteasy.wadl.jaxb.Param;
import org.jboss.resteasy.wadl.jaxb.ParamStyle;
import org.jboss.resteasy.wadl.jaxb.Representation;
import org.jboss.resteasy.wadl.jaxb.Request;
import org.jboss.resteasy.wadl.jaxb.Resource;
import org.jboss.resteasy.wadl.jaxb.Resources;
import org.jboss.resteasy.wadl.jaxb.Response;

public class ResteasyWadlWriter {
    private static final Logger logger = Logger.getLogger(ResteasyWadlWriter.class);

    public byte[] getBytes(String base, Map<String, ResteasyWadlServiceRegistry> serviceRegistries) throws JAXBException {
        StringWriter stringWriter = this.getStringWriter(base, serviceRegistries);
        return stringWriter.toString().getBytes();
    }

    public StringWriter getStringWriter(String base, Map<String, ResteasyWadlServiceRegistry> serviceRegistries) throws JAXBException {
        ObjectFactory factory = new ObjectFactory();
        Application app = factory.createApplication();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Application.class});
        Marshaller marshaller = context.createMarshaller();
        for (Map.Entry<String, ResteasyWadlServiceRegistry> entry : serviceRegistries.entrySet()) {
            String uri = base;
            if (entry.getKey() != null) {
                uri = uri + entry.getKey();
            }
            Resources resources = new Resources();
            resources.setBase(uri);
            app.getResources().add(resources);
            this.processWadl(entry.getValue(), resources);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)app, (Writer)writer);
        return stringWriter;
    }

    private void processWadl(ResteasyWadlServiceRegistry serviceRegistry, Resources root) throws JAXBException {
        for (Map.Entry<String, ResteasyWadlResourceMetaData> resourceMetaDataEntry : serviceRegistry.getResources().entrySet()) {
            logger.debug("Path: " + resourceMetaDataEntry.getKey());
            Resource resourceClass = new Resource();
            resourceClass.setPath(resourceMetaDataEntry.getKey());
            root.getResource().add(resourceClass);
            for (ResteasyWadlMethodMetaData methodMetaData : resourceMetaDataEntry.getValue().getMethodsMetaData()) {
                Method method = new Method();
                if (methodMetaData.getMethodUri() != null) {
                    Resource methodResource = new Resource();
                    methodResource.setPath(methodMetaData.getMethodUri());
                    methodResource.getMethodOrResource().add(method);
                    resourceClass.getMethodOrResource().add(methodResource);
                    this.processMethodParams(methodResource, methodMetaData, method);
                } else {
                    resourceClass.getMethodOrResource().add(method);
                    this.processMethodParams(resourceClass, methodMetaData, method);
                }
                for (String name : methodMetaData.getHttpMethods()) {
                    method.setName(name);
                }
                method.setId(methodMetaData.getMethod().getName());
                Response response = this.createResponse(serviceRegistry, methodMetaData);
                method.getResponse().add(response);
            }
        }
        for (ResteasyWadlServiceRegistry subService : serviceRegistry.getLocators()) {
            this.processWadl(subService, root);
        }
    }

    private void processMethodParams(Resource currentResourceClass, ResteasyWadlMethodMetaData methodMetaData, Method method) {
        Request request = new Request();
        for (ResteasyWadlMethodParamMetaData paramMetaData : methodMetaData.getParameters()) {
            Param param = this.createParam(currentResourceClass, method, paramMetaData, request);
        }
    }

    private Response createResponse(ResteasyWadlServiceRegistry serviceRegistry, ResteasyWadlMethodMetaData methodMetaData) {
        Response response = new Response();
        Class<?> _type = methodMetaData.getMethod().getReturnType();
        Type _generic = methodMetaData.getMethod().getGenericReturnType();
        MediaType mediaType = MediaType.WILDCARD_TYPE;
        if (methodMetaData.getProduces() != null && (mediaType = MediaType.valueOf((String)methodMetaData.getProduces())) == null && (mediaType = serviceRegistry.getProviderFactory().getConcreteMediaTypeFromMessageBodyWriters(_type, _generic, methodMetaData.getMethod().getAnnotations(), MediaType.WILDCARD_TYPE)) == null) {
            mediaType = MediaType.WILDCARD_TYPE;
        }
        Representation representation = this.createRepresentation(mediaType);
        response.getRepresentation().add(representation);
        return response;
    }

    private Param createParam(Resource currentResourceClass, Method method, ResteasyWadlMethodParamMetaData paramMetaData, Request request) {
        Param param = new Param();
        this.setType(param, paramMetaData);
        if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.PATH_PARAMETER)) {
            param.setStyle(ParamStyle.TEMPLATE);
            param.setName(paramMetaData.getParamName());
            currentResourceClass.getParam().add(param);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.COOKIE_PARAMETER)) {
            param.setStyle(ParamStyle.HEADER);
            request.getParam().add(param);
            param.setName("Cookie");
            param.setPath(paramMetaData.getParamName());
            method.setRequest(request);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.HEADER_PARAMETER)) {
            param.setStyle(ParamStyle.HEADER);
            request.getParam().add(param);
            param.setName(paramMetaData.getParamName());
            method.setRequest(request);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.MATRIX_PARAMETER)) {
            param.setStyle(ParamStyle.MATRIX);
            param.setName(paramMetaData.getParamName());
            currentResourceClass.getParam().add(param);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.QUERY_PARAMETER)) {
            param.setStyle(ParamStyle.QUERY);
            request.getParam().add(param);
            param.setName(paramMetaData.getParamName());
            method.setRequest(request);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.FORM_PARAMETER)) {
            param.setStyle(ParamStyle.QUERY);
            Representation formRepresentation = this.createFormRepresentation(request);
            param.setName(paramMetaData.getParamName());
            formRepresentation.getParam().add(param);
            method.setRequest(request);
        } else if (paramMetaData.getParamType().equals((Object)ResteasyWadlMethodParamMetaData.MethodParamType.FORM)) {
            param.setStyle(ParamStyle.QUERY);
            Representation formRepresentation = this.createFormRepresentation(request);
            param.setName(paramMetaData.getParamName());
            formRepresentation.getParam().add(param);
            method.setRequest(request);
        }
        return param;
    }

    private Representation createFormRepresentation(Request request) {
        Representation formRepresentation = this.getRepresentationByMediaType(request.getRepresentation(), MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        if (formRepresentation == null) {
            formRepresentation = this.createRepresentation(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
            request.getRepresentation().add(formRepresentation);
        }
        return formRepresentation;
    }

    private Representation createRepresentation(MediaType mediaType) {
        Representation representation = new Representation();
        representation.setMediaType(mediaType.toString());
        return representation;
    }

    private Representation getRepresentationByMediaType(List<Representation> representations, MediaType mediaType) {
        for (Representation representation : representations) {
            if (!mediaType.toString().equals(representation.getMediaType())) continue;
            return representation;
        }
        return null;
    }

    private void setType(Param param, ResteasyWadlMethodParamMetaData paramMetaData) {
        if (paramMetaData.getType().equals(Integer.TYPE) || paramMetaData.getType().equals(Integer.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "int", "xs"));
        } else if (paramMetaData.getType().equals(Boolean.TYPE) || paramMetaData.getType().equals(Boolean.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xs"));
        } else if (paramMetaData.getType().equals(Long.TYPE) || paramMetaData.getType().equals(Long.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "long", "xs"));
        } else if (paramMetaData.getType().equals(Short.TYPE) || paramMetaData.getType().equals(Short.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "short", "xs"));
        } else if (paramMetaData.getType().equals(Byte.TYPE) || paramMetaData.getType().equals(Byte.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "byte", "xs"));
        } else if (paramMetaData.getType().equals(Float.TYPE) || paramMetaData.getType().equals(Float.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "float", "xs"));
        } else if (paramMetaData.getType().equals(Double.TYPE) || paramMetaData.getType().equals(Double.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "double", "xs"));
        } else if (paramMetaData.getType().equals(Map.class) || paramMetaData.getType().equals(List.class)) {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "complex", "xs"));
        } else {
            param.setType(new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"));
        }
    }
}

