/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.wadl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.wadl.ResteasyWadlGenerator;
import org.jboss.resteasy.wadl.ResteasyWadlServiceRegistry;
import org.jboss.resteasy.wadl.ResteasyWadlServletWriter;

public class ResteasyWadlServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(ResteasyWadlServlet.class);
    private Map<String, ResteasyWadlServiceRegistry> services;
    private ResteasyWadlServletWriter apiWriter = new ResteasyWadlServletWriter();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (logger.isDebugEnabled()) {
            logger.info("Loading ResteasyWadlServlet");
        }
        this.scanResources();
        if (logger.isDebugEnabled()) {
            logger.debug("ResteasyWadlServlet loaded");
        }
        ServletContext servletContext = config.getServletContext();
        servletContext.setAttribute(((Object)((Object)this)).getClass().getName(), (Object)this);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        String uri = req.getRequestURL().toString();
        uri = uri.substring(0, uri.length() - req.getServletPath().length());
        if (logger.isDebugEnabled()) {
            logger.debug("Serving " + pathInfo);
            logger.debug("Query " + req.getQueryString());
        }
        if (this.services == null) {
            this.scanResources();
        }
        if (this.services == null) {
            resp.sendError(503, "There are no Resteasy deployments initialized yet to scan from. Either set the load-on-startup on each Resteasy servlet, or, if in an EE environment like JBoss or Wildfly, you'll have to do an invocation on each of your REST services to get the servlet loaded.");
        }
        resp.setContentType("application/xml");
        this.apiWriter.writeWadl(uri, req, resp, this.services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanResources() {
        ServletConfig config = this.getServletConfig();
        ServletContext servletContext = config.getServletContext();
        Map deployments = (Map)servletContext.getAttribute("resteasy.deployments");
        if (deployments == null) {
            return;
        }
        ResteasyWadlServlet resteasyWadlServlet = this;
        synchronized (resteasyWadlServlet) {
            this.services = new HashMap<String, ResteasyWadlServiceRegistry>();
            for (Map.Entry entry : deployments.entrySet()) {
                this.services.put((String)entry.getKey(), ResteasyWadlGenerator.generateServiceRegistry((ResteasyDeployment)entry.getValue()));
            }
        }
    }
}

