/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.vertx;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.UUID;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class VertxResourceFactory
implements ResourceFactory {
    private final ResourceFactory delegate;
    private final String id = UUID.randomUUID().toString();

    public VertxResourceFactory(ResourceFactory delegate) {
        this.delegate = delegate;
    }

    public Class<?> getScannableClass() {
        return this.delegate.getScannableClass();
    }

    public void registered(ResteasyProviderFactory factory) {
        this.delegate.registered(factory);
    }

    public Object createResource(HttpRequest request, HttpResponse response, ResteasyProviderFactory factory) {
        Context ctx = Vertx.factory.context();
        if (ctx != null) {
            Object resource = ctx.get(this.id);
            if (resource == null) {
                resource = this.delegate.createResource(request, response, factory);
                ctx.put(this.id, resource);
            }
            return resource;
        }
        throw new IllegalStateException();
    }

    public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
        this.delegate.requestFinished(request, response, resource);
    }

    public void unregistered() {
        this.delegate.unregistered();
    }
}

