/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.embedded.server;

import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.ext.Provider;
import org.jboss.resteasy.cdi.CdiInjectorFactory;
import org.jboss.resteasy.core.ResteasyDeploymentImpl;
import org.jboss.resteasy.spi.DelegateResteasyDeployment;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.weld.environment.ContainerInstance;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;

class CdiResteasyDeployment
extends DelegateResteasyDeployment
implements ResteasyDeployment {
    private final Weld weld;
    private final Object lock = new Object();
    private WeldContainer container;
    private ResteasyDeployment delegate;

    CdiResteasyDeployment() {
        super(null);
        this.weld = new Weld("RESTEasy SE").addBeanDefiningAnnotations(new Class[]{Path.class, Provider.class, ApplicationPath.class});
        this.delegate = new ResteasyDeploymentImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            super.setInjectorFactory((InjectorFactory)new CdiInjectorFactory(this.getContainer().getBeanManager()));
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            ResteasyDeployment newDelegate = CdiResteasyDeployment.newDelegate(this.delegate);
            this.delegate.stop();
            this.delegate = newDelegate;
            this.weld.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResteasyDeployment getDelegate() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContainerInstance getContainer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.container == null || !this.container.isRunning()) {
                this.container = this.weld.initialize();
            }
        }
        return this.container;
    }

    private static ResteasyDeployment newDelegate(ResteasyDeployment old) {
        ResteasyDeploymentImpl deployment = new ResteasyDeploymentImpl();
        deployment.merge(old);
        deployment.setApplication(old.getApplication());
        deployment.setApplicationClass(old.getApplicationClass());
        return deployment;
    }
}

