/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.jboss.resteasy.auth.oauth.OAuthException;
import org.jboss.resteasy.auth.oauth.OAuthProvider;
import org.jboss.resteasy.auth.oauth.OAuthProviderChecker;
import org.jboss.resteasy.auth.oauth.OAuthValidator;
import org.jboss.resteasy.auth.oauth.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthUtils {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final String OAUTH_VERIFIER_PARAM = "oauth_verifier";
    public static final String OAUTH_CALLBACK_CONFIRMED_PARAM = "oauth_callback_confirmed";
    private static final String ATTR_OAUTH_VALIDATOR = OAuthValidator.class.getName();
    private static final String ATTR_OAUTH_PROVIDER = OAuthProvider.class.getName();
    private static final Logger logger = LoggerFactory.getLogger(OAuthUtils.class);

    public static String encodeForOAuth(String value) {
        try {
            return URLUtils.encodePart(value, "UTF-8", URLUtils.UNRESERVED);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 encoding should be supported", e);
        }
    }

    public static void sendValues(HttpServletResponse resp, String ... params) throws IOException {
        PrintWriter writer = resp.getWriter();
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Arguments should be name=value*");
        }
        for (int i = 0; i < params.length; i += 2) {
            if (i > 0) {
                writer.append('&');
            }
            writer.append(OAuthUtils.encodeForOAuth(params[i]));
            writer.append('=');
            writer.append(OAuthUtils.encodeForOAuth(params[i + 1]));
        }
    }

    public static OAuthMessage readMessage(HttpServletRequest req) {
        String authorizationHeader = req.getHeader(AUTHORIZATION_HEADER);
        HashSet<OAuth.Parameter> parameters = new HashSet<OAuth.Parameter>();
        if (authorizationHeader != null) {
            for (OAuth.Parameter param : OAuthMessage.decodeAuthorization((String)authorizationHeader)) {
                if ("realm".equalsIgnoreCase(param.getValue())) continue;
                parameters.add(param);
            }
        }
        ArrayList<String> parameterNames = Collections.list(req.getParameterNames());
        for (String parameterName : parameterNames) {
            for (String value : req.getParameterValues(parameterName)) {
                logger.debug("Adding parameter " + parameterName + " => " + value);
                parameters.add(new OAuth.Parameter(parameterName, value));
            }
        }
        return new OAuthMessage(req.getMethod(), req.getRequestURL().toString(), parameters);
    }

    public static void makeErrorResponse(HttpServletResponse resp, String message, int httpCode, OAuthProvider provider) throws IOException {
        logger.debug("Error [" + httpCode + "]: " + message);
        resp.getWriter().append(message);
        resp.setStatus(httpCode);
        resp.setHeader(AUTHENTICATE_HEADER, "OAuth realm=\"" + provider.getRealm() + "\"");
    }

    public static long parseTimestamp(String timestampString) throws OAuthException {
        try {
            long timestamp = Long.parseLong(timestampString);
            if (timestamp > 0L) {
                return timestamp;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new OAuthException(401, "Invalid timestamp " + timestampString);
    }

    public static int getHttpCode(OAuthProblemException x) {
        Integer httpCode = (Integer)OAuth.Problems.TO_HTTP_CODE.get(x.getProblem());
        if (httpCode != null) {
            return httpCode;
        }
        return 500;
    }

    public static OAuthProvider getOAuthProvider(ServletContext context) throws ServletException {
        OAuthProvider provider = (OAuthProvider)context.getAttribute(ATTR_OAUTH_PROVIDER);
        if (provider != null) {
            return provider;
        }
        String providerClassName = context.getInitParameter("oauth.provider.provider-class");
        if (providerClassName == null) {
            throw new ServletException("oauth.provider.provider-class parameter required");
        }
        try {
            logger.info("Loading OAuthProvider: " + providerClassName);
            Class<?> providerClass = Class.forName(providerClassName);
            if (!OAuthProvider.class.isAssignableFrom(providerClass)) {
                throw new ServletException("oauth.provider.provider-class class " + providerClassName + " must be an instance of OAuthProvider");
            }
            provider = new OAuthProviderChecker((OAuthProvider)providerClass.newInstance());
            context.setAttribute(ATTR_OAUTH_PROVIDER, (Object)provider);
            return provider;
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("oauth.provider.provider-class class " + providerClassName + " not found");
        }
        catch (Exception e) {
            throw new ServletException("oauth.provider.provider-class class " + providerClassName + " could not be instanciated", (Throwable)e);
        }
    }

    public static OAuthValidator getValidator(ServletContext context, OAuthProvider provider) {
        OAuthValidator validator = (OAuthValidator)((Object)context.getAttribute(ATTR_OAUTH_VALIDATOR));
        if (validator != null) {
            return validator;
        }
        validator = new OAuthValidator(provider);
        context.setAttribute(ATTR_OAUTH_VALIDATOR, (Object)validator);
        return validator;
    }
}

