/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import org.jboss.resteasy.auth.oauth.OAuthConsumer;
import org.jboss.resteasy.auth.oauth.OAuthException;
import org.jboss.resteasy.auth.oauth.OAuthProvider;
import org.jboss.resteasy.auth.oauth.OAuthToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthProviderChecker
implements OAuthProvider {
    private OAuthProvider provider;

    public OAuthProviderChecker(OAuthProvider provider) {
        this.provider = provider;
    }

    private <T> T checkNull(T arg) {
        if (arg == null) {
            throw new RuntimeException("OAuthProvider should not return null");
        }
        return arg;
    }

    @Override
    public OAuthConsumer getConsumer(String consumerKey) throws OAuthException {
        return this.checkNull(this.provider.getConsumer(consumerKey));
    }

    @Override
    public String getRealm() {
        return this.checkNull(this.provider.getRealm());
    }

    @Override
    public OAuthToken getRequestToken(String consumerKey, String requestKey) throws OAuthException {
        return this.checkNull(this.provider.getRequestToken(consumerKey, requestKey));
    }

    @Override
    public OAuthToken getAccessToken(String consumerKey, String accessKey) throws OAuthException {
        return this.checkNull(this.provider.getAccessToken(consumerKey, accessKey));
    }

    @Override
    public void checkTimestamp(OAuthToken token, long timestamp) throws OAuthException {
        this.provider.checkTimestamp(token, timestamp);
    }

    @Override
    public OAuthToken makeAccessToken(String consumerKey, String requestKey, String verifier) throws OAuthException {
        return this.checkNull(this.provider.makeAccessToken(consumerKey, requestKey, verifier));
    }

    @Override
    public OAuthToken makeRequestToken(String consumerKey, String callback) throws OAuthException {
        return this.checkNull(this.provider.makeRequestToken(consumerKey, callback));
    }

    @Override
    public String authoriseRequestToken(String consumerKey, String requestKey) throws OAuthException {
        return this.checkNull(this.provider.authoriseRequestToken(consumerKey, requestKey));
    }
}

