/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.resteasy.plugins.server.netty.ChunkOutputStream;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpResponseEncoder;
import org.jboss.resteasy.plugins.server.netty.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class NettyHttpResponse
implements HttpResponse {
    private static final int EMPTY_CONTENT_LENGTH = 0;
    private int status = 200;
    private OutputStream os;
    private final MultivaluedMap<String, Object> outputHeaders = new MultivaluedMapImpl();
    private final ChannelHandlerContext ctx;
    private boolean committed;
    private final boolean keepAlive;
    private final ResteasyProviderFactory providerFactory;
    private final HttpMethod method;

    public NettyHttpResponse(ChannelHandlerContext ctx, boolean keepAlive, ResteasyProviderFactory providerFactory) {
        this(ctx, keepAlive, providerFactory, null);
    }

    public NettyHttpResponse(ChannelHandlerContext ctx, boolean keepAlive, ResteasyProviderFactory providerFactory, HttpMethod method) {
        this.method = method;
        this.os = method == null || !method.equals((Object)HttpMethod.HEAD) ? new ChunkOutputStream(this, ctx, 1000) : null;
        this.ctx = ctx;
        this.keepAlive = keepAlive;
        this.providerFactory = providerFactory;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add((Object)"Set-Cookie", (Object)cookie);
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.setStatus(status);
        DefaultFullHttpResponse response = null;
        if (message != null) {
            byte[] messageBytes = message.getBytes();
            ByteBuf byteBuf = this.ctx.alloc().buffer();
            byteBuf.writeBytes(messageBytes);
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(status, message), byteBuf);
            response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)messageBytes.length);
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)status));
            response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        }
        this.transformResponseHeaders((io.netty.handler.codec.http.HttpResponse)response);
        this.ctx.writeAndFlush((Object)response);
        this.committed = true;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException(Messages.MESSAGES.alreadyCommitted());
        }
        this.outputHeaders.clear();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public DefaultHttpResponse getDefaultHttpResponse() {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.getStatus()));
        this.transformResponseHeaders((io.netty.handler.codec.http.HttpResponse)res);
        return res;
    }

    public DefaultHttpResponse getEmptyHttpResponse() {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.getStatus()));
        if (this.method == null || !this.method.equals((Object)HttpMethod.HEAD)) {
            res.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        }
        this.transformResponseHeaders((io.netty.handler.codec.http.HttpResponse)res);
        return res;
    }

    private void transformResponseHeaders(io.netty.handler.codec.http.HttpResponse res) {
        RestEasyHttpResponseEncoder.transformHeaders(this, res, this.providerFactory);
    }

    public void prepareChunkStream() {
        this.committed = true;
        DefaultHttpResponse response = this.getDefaultHttpResponse();
        HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
        this.ctx.write((Object)response);
    }

    public void finish() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
        ChannelFuture future = this.isCommitted() ? this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT) : this.ctx.writeAndFlush((Object)this.getEmptyHttpResponse());
        if (!this.isKeepAlive()) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void flushBuffer() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
        this.ctx.flush();
    }
}

