/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpResponse;

public class NettyHttpResponse
implements HttpResponse {
    private int status = 200;
    private ByteBuf byteBuf;
    private OutputStream os;
    private MultivaluedMap<String, Object> outputHeaders = new MultivaluedMapImpl();
    private final ChannelHandlerContext ctx;
    private boolean committed;
    private boolean keepAlive;

    public NettyHttpResponse(ChannelHandlerContext ctx, boolean keepAlive) {
        this.byteBuf = ctx.alloc().buffer();
        this.os = new ByteBufOutputStream(this.byteBuf);
        this.ctx = ctx;
        this.keepAlive = keepAlive;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public ByteBuf getBuffer() {
        return this.byteBuf;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add((Object)"Set-Cookie", (Object)cookie);
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        HttpResponseStatus responseStatus;
        if (this.committed) {
            throw new IllegalStateException();
        }
        if (message != null) {
            responseStatus = new HttpResponseStatus(status, message);
            this.setStatus(status);
        } else {
            responseStatus = HttpResponseStatus.valueOf((int)status);
            this.setStatus(status);
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus);
        if (this.keepAlive) {
            response.headers().add("Connection", (Object)"keep-alive");
            response.headers().add("Content-Length", (Object)0);
        }
        this.ctx.writeAndFlush((Object)response);
        this.committed = true;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException("Already committed");
        }
        this.outputHeaders.clear();
        this.byteBuf.clear();
        this.outputHeaders.clear();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void retain() {
        this.byteBuf.retain(1);
    }

    public DefaultFullHttpResponse getDefaultFullHttpResponse() {
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)this.getStatus());
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, this.getBuffer());
    }
}

