/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import java.io.InputStream;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.NettyUtil;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.ResteasyUriInfo;

@ChannelHandler.Sharable
public class RestEasyHttpRequestDecoder
extends OneToOneDecoder {
    private static final Logger logger = Logger.getLogger(RestEasyHttpRequestDecoder.class);
    private final SynchronousDispatcher dispatcher;
    private final String servletMappingPrefix;
    private final String proto;

    public RestEasyHttpRequestDecoder(SynchronousDispatcher dispatcher, String servletMappingPrefix, Protocol protocol) {
        this.dispatcher = dispatcher;
        this.servletMappingPrefix = servletMappingPrefix;
        this.proto = protocol == Protocol.HTTP ? "http" : "https";
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof HttpRequest)) {
            return msg;
        }
        HttpRequest request = (HttpRequest)msg;
        boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
        NettyHttpResponse response = new NettyHttpResponse(channel, keepAlive);
        ResteasyHttpHeaders headers = null;
        ResteasyUriInfo uriInfo = null;
        try {
            headers = NettyUtil.extractHttpHeaders(request);
            uriInfo = NettyUtil.extractUriInfo(request, this.servletMappingPrefix, this.proto);
            NettyHttpRequest nettyRequest = new NettyHttpRequest(headers, uriInfo, request.getMethod().getName(), this.dispatcher, response, HttpHeaders.is100ContinueExpected((HttpMessage)request));
            ChannelBufferInputStream is = new ChannelBufferInputStream(request.getContent());
            nettyRequest.setInputStream((InputStream)is);
            return nettyRequest;
        }
        catch (Exception e) {
            response.sendError(400);
            logger.warn("Failed to parse request.", (Throwable)e);
            return null;
        }
    }

    public static enum Protocol {
        HTTPS,
        HTTP;

    }
}

