/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jsonb;

import java.nio.charset.Charset;
import javax.json.bind.Jsonb;
import javax.json.spi.JsonProvider;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.eclipse.yasson.JsonBindingProvider;
import org.eclipse.yasson.internal.JsonBindingBuilder;
import org.glassfish.json.JsonProviderImpl;

public class AbstractJsonBindingProvider
extends JsonBindingProvider {
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";
    @Context
    Providers providers;
    private static Jsonb jsonbObj = null;

    protected Jsonb getJsonb(Class<?> type) {
        ContextResolver contextResolver = this.providers.getContextResolver(Jsonb.class, MediaType.APPLICATION_JSON_TYPE);
        if (contextResolver != null) {
            return (Jsonb)contextResolver.getContext(type);
        }
        if (jsonbObj == null) {
            JsonProviderImpl jProviderImpl = new JsonProviderImpl();
            JsonBindingBuilder jbBuilder = new JsonBindingBuilder();
            jsonbObj = jbBuilder.withProvider((JsonProvider)jProviderImpl).build();
        }
        return jsonbObj;
    }

    public static Charset getCharset(MediaType mediaType) {
        return Charset.forName("utf-8");
    }

    public static boolean isSupportedMediaType(MediaType mediaType) {
        return mediaType.getSubtype().equals(JSON) || mediaType.getSubtype().endsWith(PLUS_JSON);
    }
}

