/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.sun.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsServer;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.util.CookieParser;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.PathHelper;

public class HttpExchangeUtil {
    public static ResteasyUriInfo extractUriInfo(HttpExchange exchange) {
        Object host = exchange.getLocalAddress().getHostName();
        if (exchange.getLocalAddress().getPort() != 80 && exchange.getLocalAddress().getPort() != 443) {
            host = (String)host + ":" + exchange.getLocalAddress().getPort();
        }
        String uri = exchange.getRequestURI().toString();
        String protocol = exchange.getHttpContext().getServer() instanceof HttpsServer ? "https" : "http";
        URI absoluteURI = URI.create(protocol + "://" + (String)host + uri);
        String contextPath = exchange.getHttpContext().getPath();
        Object path = PathHelper.getEncodedPathInfo((String)absoluteURI.getRawPath(), (String)contextPath);
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        URI baseURI = absoluteURI;
        if (!((String)path).trim().equals("")) {
            Object tmpContextPath = contextPath;
            if (!((String)tmpContextPath).endsWith("/")) {
                tmpContextPath = (String)tmpContextPath + "/";
            }
            baseURI = UriBuilder.fromUri((URI)absoluteURI).replacePath((String)tmpContextPath).replaceQuery(null).build(new Object[0]);
        } else {
            baseURI = UriBuilder.fromUri((URI)absoluteURI).replaceQuery(null).build(new Object[0]);
        }
        URI relativeURI = UriBuilder.fromUri((String)path).replaceQuery(absoluteURI.getRawQuery()).build(new Object[0]);
        ResteasyUriInfo uriInfo = new ResteasyUriInfo(baseURI, relativeURI);
        return uriInfo;
    }

    public static ResteasyHttpHeaders extractHttpHeaders(HttpExchange request) {
        MultivaluedMap<String, String> requestHeaders = HttpExchangeUtil.extractRequestHeaders(request);
        ResteasyHttpHeaders headers = new ResteasyHttpHeaders(requestHeaders);
        Map<String, Cookie> cookies = HttpExchangeUtil.extractCookies(requestHeaders);
        headers.setCookies(cookies);
        headers.testParsing();
        return headers;
    }

    static Map<String, Cookie> extractCookies(MultivaluedMap<String, String> headers) {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        List cookieHeaders = (List)headers.get((Object)"Cookie");
        if (cookieHeaders == null) {
            return cookies;
        }
        for (String cookieHeader : cookieHeaders) {
            for (Cookie cookie : CookieParser.parseCookies((String)cookieHeader)) {
                cookies.put(cookie.getName(), cookie);
            }
        }
        return cookies;
    }

    public static List<MediaType> extractAccepts(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        List accepts = (List)requestHeaders.get((Object)"Accept");
        if (accepts == null) {
            return acceptableMediaTypes;
        }
        for (String accept : accepts) {
            acceptableMediaTypes.addAll(MediaTypeHelper.parseHeader((String)accept));
        }
        return acceptableMediaTypes;
    }

    public static List<String> extractLanguages(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<String> acceptable = new ArrayList<String>();
        List accepts = (List)requestHeaders.get((Object)"Accept-Language");
        if (accepts == null) {
            return acceptable;
        }
        for (String accept : accepts) {
            String[] splits;
            for (String split : splits = accept.split(",")) {
                acceptable.add(split.trim());
            }
        }
        return acceptable;
    }

    public static MultivaluedMap<String, String> extractRequestHeaders(HttpExchange request) {
        Headers requestHeaders = new Headers();
        for (Map.Entry<String, List<String>> header : request.getRequestHeaders().entrySet()) {
            for (String val : header.getValue()) {
                requestHeaders.add((Object)header.getKey(), (Object)val);
            }
        }
        return requestHeaders;
    }
}

