/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.sun.http;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import org.jboss.resteasy.core.ResteasyDeploymentImpl;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.sun.http.BasicAuthFilter;
import org.jboss.resteasy.plugins.server.sun.http.HttpContextResteasyConfiguration;
import org.jboss.resteasy.plugins.server.sun.http.ResteasyHttpHandler;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class HttpContextBuilder {
    protected ResteasyDeployment deployment = new ResteasyDeploymentImpl();
    protected String path = "/";
    protected ResteasyHttpHandler handler;
    protected SecurityDomain securityDomain;
    protected HttpContext boundContext;

    public ResteasyDeployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(ResteasyDeployment deployment) {
        this.deployment = deployment;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        if (!this.path.startsWith("/")) {
            this.path = "/" + path;
        }
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(SecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public HttpContext bind(HttpServer server) {
        this.handler = new ResteasyHttpHandler();
        this.boundContext = server.createContext(this.path, this.handler);
        HttpContextResteasyConfiguration config = new HttpContextResteasyConfiguration(this.boundContext);
        this.deployment.getDefaultContextObjects().put(ResteasyConfiguration.class, config);
        if (this.securityDomain != null) {
            this.boundContext.getFilters().add(new BasicAuthFilter(this.securityDomain));
        }
        this.deployment.start();
        this.handler.setDispatcher(this.deployment.getDispatcher());
        this.handler.setProviderFactory(this.deployment.getProviderFactory());
        return this.boundContext;
    }

    public void cleanup() {
        this.deployment.stop();
    }
}

