/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.html;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.WebApplicationException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.plugins.providers.html.Renderable;
import org.jboss.resteasy.plugins.providers.html.i18n.Messages;
import org.jboss.resteasy.spi.InternalServerErrorException;

public class View
implements Renderable {
    public static final String DEFAULT_MODEL_NAME = "model";
    protected String path;
    protected Map<String, Object> model = new HashMap<String, Object>();

    public View(String path) {
        this(path, null, null);
    }

    public View(String path, Object model) {
        this(path, model, DEFAULT_MODEL_NAME);
    }

    public View(String path, Object model, String modelName) {
        this.path = path;
        if (modelName != null) {
            this.setValue(modelName, model);
        }
    }

    private Object setValue(String variable, Object model) {
        return this.model.put(variable, model);
    }

    public String getPath() {
        return this.path;
    }

    private <T> T getFirst(Collection<T> values) {
        return values.isEmpty() ? null : (T)values.iterator().next();
    }

    public String getModelName() {
        return this.getFirst(this.model.keySet());
    }

    public Object getModel() {
        return this.getFirst(this.model.values());
    }

    public Map<String, Object> getModelMap() {
        return this.model;
    }

    @Override
    public void render(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, WebApplicationException {
        for (Map.Entry<String, Object> entry : this.model.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
        RequestDispatcher disp = request.getRequestDispatcher(this.path);
        if (disp == null) {
            throw new InternalServerErrorException(Messages.MESSAGES.noDispatcherFound(this.path));
        }
        disp.forward((ServletRequest)request, (ServletResponse)response);
    }
}

