/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.embedded.test.interceptor;

import dev.resteasy.junit.extension.annotations.RequestPath;
import dev.resteasy.junit.extension.annotations.RestBootstrap;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.logging.Logger;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionClientRequestFilter1;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionClientRequestFilter2;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionClientRequestFilter3;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionClientRequestFilterMax;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionClientRequestFilterMin;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionClientResponseFilter1;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionClientResponseFilter2;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionClientResponseFilter3;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionClientResponseFilterMax;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionClientResponseFilterMin;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionContainerRequestFilter1;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionContainerRequestFilter2;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionContainerRequestFilter3;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionContainerRequestFilterMax;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionContainerRequestFilterMin;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionContainerResponseFilter1;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionContainerResponseFilter2;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionContainerResponseFilter3;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionContainerResponseFilterMax;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionContainerResponseFilterMin;
import org.jboss.resteasy.embedded.test.interceptor.resource.PriorityExecutionResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@RestBootstrap(value=PriorityApplication.class)
public class PriorityExecutionTest {
    public static volatile Queue<String> interceptors = new ConcurrentLinkedQueue<String>();
    public static Logger logger = Logger.getLogger(PriorityExecutionTest.class);
    private static final String WRONG_ORDER_ERROR_MSG = "Wrong order of interceptor execution";

    @Test
    public void testPriority(Client client, @RequestPath(value="test") URI uri) throws Exception {
        client.register(PriorityExecutionClientResponseFilter3.class);
        client.register(PriorityExecutionClientResponseFilter1.class);
        client.register(PriorityExecutionClientResponseFilter2.class);
        client.register(PriorityExecutionClientResponseFilterMin.class);
        client.register(PriorityExecutionClientResponseFilterMax.class);
        client.register(PriorityExecutionClientRequestFilter3.class);
        client.register(PriorityExecutionClientRequestFilter1.class);
        client.register(PriorityExecutionClientRequestFilter2.class);
        client.register(PriorityExecutionClientRequestFilterMin.class);
        client.register(PriorityExecutionClientRequestFilterMax.class);
        Response response = client.target(uri).request().get();
        response.bufferEntity();
        logger.info(response.readEntity(String.class));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"test", (Object)response.getEntity(), (String)"Wrong content of response");
        Assertions.assertEquals((Object)"PriorityExecutionClientRequestFilterMin", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionClientRequestFilter1", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionClientRequestFilter2", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionClientRequestFilter3", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionClientRequestFilterMax", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionContainerRequestFilterMin", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionContainerRequestFilter1", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionContainerRequestFilter2", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionContainerRequestFilter3", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionContainerRequestFilterMax", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionContainerResponseFilterMax", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionContainerResponseFilter3", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionContainerResponseFilter2", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionContainerResponseFilter1", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionContainerResponseFilterMin", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionClientResponseFilterMax", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionClientResponseFilter3", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionClientResponseFilter2", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionClientResponseFilter1", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
        Assertions.assertEquals((Object)"PriorityExecutionClientResponseFilterMin", (Object)interceptors.poll(), (String)WRONG_ORDER_ERROR_MSG);
    }

    public static class PriorityApplication
    extends Application {
        public Set<Class<?>> getClasses() {
            return Set.of(PriorityExecutionResource.class, PriorityExecutionContainerResponseFilter2.class, PriorityExecutionContainerResponseFilter1.class, PriorityExecutionContainerResponseFilter3.class, PriorityExecutionContainerResponseFilterMin.class, PriorityExecutionContainerResponseFilterMax.class, PriorityExecutionContainerRequestFilter2.class, PriorityExecutionContainerRequestFilter1.class, PriorityExecutionContainerRequestFilter3.class, PriorityExecutionContainerRequestFilterMin.class, PriorityExecutionContainerRequestFilterMax.class);
        }
    }
}

