/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.threads;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.standardutils.threads.ExecutionController;
import se.unlogic.standardutils.threads.TaskGroup;
import se.unlogic.standardutils.threads.ThreadPoolTaskGroupHandler;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLAttribute;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLGenerator;

@XMLElement(name="ExecutionController")
public class SimpleExecutionController<T extends TaskGroup>
implements ExecutionController<T>,
Elementable {
    private final ReentrantLock globalLock = new ReentrantLock();
    private Condition finishedCondition = this.globalLock.newCondition();
    private T taskGroup;
    private BlockingQueue<? extends Runnable> taskQueue;
    private ThreadPoolTaskGroupHandler<T> threadPoolTaskHandler;
    @XMLAttribute
    private boolean started;
    @XMLAttribute
    private boolean aborted;
    @XMLAttribute
    private int initialTaskCount;
    @XMLAttribute
    private AtomicInteger completedTaskCount = new AtomicInteger();

    public SimpleExecutionController(T taskGroup, ThreadPoolTaskGroupHandler<T> threadPoolTaskHandler) {
        this.taskGroup = taskGroup;
        this.taskQueue = taskGroup.getTasks();
        this.threadPoolTaskHandler = threadPoolTaskHandler;
        this.initialTaskCount = this.taskQueue.size();
    }

    @Override
    public void abort() {
        this.globalLock.lock();
        try {
            if (this.threadPoolTaskHandler != null) {
                if (this.started) {
                    this.threadPoolTaskHandler.remove(this);
                }
                this.aborted = true;
                this.executionComplete();
            }
        }
        finally {
            this.globalLock.unlock();
        }
    }

    @Override
    public void awaitExecution(long timeout) throws InterruptedException {
        this.globalLock.lock();
        try {
            if (this.finishedCondition != null) {
                this.finishedCondition.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.globalLock.unlock();
        }
    }

    @Override
    public void awaitExecution() throws InterruptedException {
        this.globalLock.lock();
        try {
            if (this.finishedCondition != null) {
                this.finishedCondition.await();
            }
        }
        finally {
            this.globalLock.unlock();
        }
    }

    void executionComplete() {
        this.globalLock.lock();
        try {
            if (this.finishedCondition != null) {
                this.finishedCondition.signalAll();
                this.threadPoolTaskHandler = null;
                this.finishedCondition = null;
            }
        }
        finally {
            this.globalLock.unlock();
        }
    }

    @Override
    public int getRemainingTaskCount() {
        return this.taskQueue.size();
    }

    BlockingQueue<? extends Runnable> getTaskQueue() {
        return this.taskQueue;
    }

    @Override
    public void start() {
        this.globalLock.lock();
        try {
            if (!this.started && !this.aborted) {
                this.threadPoolTaskHandler.add(this);
                this.started = true;
            }
        }
        finally {
            this.globalLock.unlock();
        }
    }

    public int getInitialTaskCount() {
        return this.initialTaskCount;
    }

    public int getCompletedTaskCount() {
        return this.completedTaskCount.get();
    }

    void incrementCompletedTaskCount() {
        this.completedTaskCount.incrementAndGet();
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public boolean isFinished() {
        return this.started && !this.aborted && this.threadPoolTaskHandler == null;
    }

    @Override
    public T getTaskGroup() {
        return this.taskGroup;
    }

    @Override
    public Element toXML(Document doc) {
        return XMLGenerator.toXML(this, doc);
    }
}

