/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import org.jboss.resteasy.annotations.security.doseta.After;
import org.jboss.resteasy.annotations.security.doseta.Verifications;
import org.jboss.resteasy.annotations.security.doseta.Verify;
import org.jboss.resteasy.security.doseta.Verification;
import org.jboss.resteasy.security.doseta.Verifier;

public class AbstractDigitalVerificationHeaderDecorator {
    protected Verify verify;
    protected Verifications verifications;

    public Verifier create() {
        Verifier verifier = new Verifier();
        if (this.verify != null) {
            Verification v = this.createVerification(this.verify);
            verifier.getVerifications().add(v);
        }
        if (this.verifications != null) {
            for (Verify ver : this.verifications.value()) {
                Verification v = this.createVerification(ver);
                verifier.getVerifications().add(v);
            }
        }
        return verifier;
    }

    protected Verification createVerification(Verify v) {
        Verification verification = new Verification();
        if (v.identifierName() != null && !v.identifierName().trim().equals("")) {
            verification.setIdentifierName(v.identifierName());
        }
        if (v.identifierValue() != null && !v.identifierValue().trim().equals("")) {
            verification.setIdentifierValue(v.identifierValue());
        }
        verification.setIgnoreExpiration(v.ignoreExpiration());
        After staleAfter = v.stale();
        if (staleAfter.seconds() > 0 || staleAfter.minutes() > 0 || staleAfter.hours() > 0 || staleAfter.days() > 0 || staleAfter.months() > 0 || staleAfter.years() > 0) {
            verification.setStaleCheck(true);
            verification.setStaleSeconds(staleAfter.seconds());
            verification.setStaleMinutes(staleAfter.minutes());
            verification.setStaleHours(staleAfter.hours());
            verification.setStaleDays(staleAfter.days());
            verification.setStaleMonths(staleAfter.months());
            verification.setStaleYears(staleAfter.years());
        }
        verification.setBodyHashRequired(v.bodyHashRequired());
        return verification;
    }
}

