/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.smime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.jboss.resteasy.security.BouncyIntegration;
import org.jboss.resteasy.security.smime.SignedOutput;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.WriterException;

@Provider
@Produces(value={"application/pkcs7-signature"})
public class PKCS7SignatureWriter
implements MessageBodyWriter<SignedOutput> {
    @Context
    protected Providers providers;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return SignedOutput.class.isAssignableFrom(type);
    }

    public long getSize(SignedOutput smimeOutput, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(SignedOutput out, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        try {
            byte[] encoded = PKCS7SignatureWriter.sign(this.providers, out);
            headers.putSingle((Object)"Content-Type", (Object)"application/pkcs7-signature;micalg=\"sha1\"");
            os.write(encoded);
        }
        catch (Exception e) {
            throw new WriterException((Throwable)e);
        }
    }

    public static byte[] sign(Providers providers, SignedOutput out) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        ByteArrayOutputStream bodyOs = new ByteArrayOutputStream();
        MessageBodyWriter writer = providers.getMessageBodyWriter(out.getType(), out.getGenericType(), null, out.getMediaType());
        if (writer == null) {
            throw new WriterException("Failed to find writer for type: " + out.getType().getName());
        }
        MultivaluedMapImpl bodyHeaders = new MultivaluedMapImpl();
        bodyHeaders.add((Object)"Content-Type", (Object)out.getMediaType().toString());
        writer.writeTo(out.getEntity(), out.getType(), out.getGenericType(), null, out.getMediaType(), (MultivaluedMap)bodyHeaders, (OutputStream)bodyOs);
        CMSSignedDataGenerator signGen = new CMSSignedDataGenerator();
        signGen.addSigner(out.getPrivateKey(), out.getCertificate(), CMSSignedDataGenerator.DIGEST_SHA1);
        CMSProcessableByteArray content = new CMSProcessableByteArray(bodyOs.toByteArray());
        CMSSignedData signedData = signGen.generate((CMSProcessable)content, true, "BC");
        return signedData.getEncoded();
    }

    static {
        BouncyIntegration.init();
    }
}

