/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.DecoderPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.crypto.i18n.Messages;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.security.doseta.UnauthorizedSignatureException;
import org.jboss.resteasy.security.doseta.VerificationResults;
import org.jboss.resteasy.security.doseta.Verifier;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.MessageBodyReaderContext;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.util.InputStreamToByteArray;

@Provider
@ClientInterceptor
@ServerInterceptor
@DecoderPrecedence
public class DigitalVerificationInterceptor
implements MessageBodyReaderInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(MessageBodyReaderContext context) throws IOException, WebApplicationException {
        Verifier verifier = (Verifier)context.getAttribute(Verifier.class.getName());
        if (verifier == null) {
            return context.proceed();
        }
        MultivaluedMap headers = context.getHeaders();
        List strings = (List)headers.get((Object)"DKIM-Signature");
        if (strings == null) {
            throw new UnauthorizedSignatureException(Messages.MESSAGES.thereWasNoSignatureHeader("DKIM-Signature"));
        }
        ArrayList<DKIMSignature> signatures = new ArrayList<DKIMSignature>();
        for (String headerVal : strings) {
            try {
                signatures.add(new DKIMSignature(headerVal));
            }
            catch (Exception e) {
                throw new UnauthorizedSignatureException(Messages.MESSAGES.malformedSignatureHeader("DKIM-Signature"));
            }
        }
        InputStream old = context.getInputStream();
        try {
            VerificationResults results;
            InputStreamToByteArray stream = new InputStreamToByteArray(old);
            context.setInputStream((InputStream)stream);
            Object rtn = context.proceed();
            byte[] body = stream.toByteArray();
            if (verifier.getRepository() == null) {
                KeyRepository repository = (KeyRepository)context.getAttribute(KeyRepository.class.getName());
                if (repository == null) {
                    repository = (KeyRepository)ResteasyProviderFactory.getContextData(KeyRepository.class);
                }
                verifier.setRepository(repository);
            }
            if (!(results = verifier.verify(signatures, (Map)headers, body)).isVerified()) {
                throw new UnauthorizedSignatureException(results);
            }
            Object object = rtn;
            return object;
        }
        finally {
            context.setInputStream(old);
        }
    }
}

