/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.HeaderDecoratorPrecedence;
import org.jboss.resteasy.annotations.security.doseta.After;
import org.jboss.resteasy.annotations.security.doseta.Verifications;
import org.jboss.resteasy.annotations.security.doseta.Verify;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.security.doseta.Verification;
import org.jboss.resteasy.security.doseta.Verifier;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.AcceptedByMethod;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;

@Provider
@HeaderDecoratorPrecedence
public class DigitalVerificationHeaderDecorator
implements ClientExecutionInterceptor,
PreProcessInterceptor,
AcceptedByMethod {
    protected Verify verify;
    protected Verifications verifications;

    public boolean accept(Class declaring, Method method) {
        this.verify = method.getAnnotation(Verify.class);
        this.verifications = method.getAnnotation(Verifications.class);
        return this.verify != null || this.verifications != null;
    }

    public ClientResponse execute(ClientExecutionContext ctx) throws Exception {
        ClientResponse response = ctx.proceed();
        response.getAttributes().put(Verifier.class.getName(), this.create());
        return response;
    }

    public ServerResponse preProcess(HttpRequest request, ResourceMethod method) throws Failure, WebApplicationException {
        request.setAttribute(Verifier.class.getName(), (Object)this.create());
        return null;
    }

    public Verifier create() {
        Verifier verifier = new Verifier();
        if (this.verify != null) {
            Verification v = this.createVerification(this.verify);
            verifier.getVerifications().add(v);
        }
        if (this.verifications != null) {
            for (Verify ver : this.verifications.value()) {
                Verification v = this.createVerification(ver);
                verifier.getVerifications().add(v);
            }
        }
        return verifier;
    }

    protected Verification createVerification(Verify v) {
        Verification verification = new Verification();
        if (v.identifierName() != null && !v.identifierName().trim().equals("")) {
            verification.setIdentifierName(v.identifierName());
        }
        if (v.identifierValue() != null && !v.identifierValue().trim().equals("")) {
            verification.setIdentifierValue(v.identifierValue());
        }
        verification.setIgnoreExpiration(v.ignoreExpiration());
        After staleAfter = v.stale();
        if (staleAfter.seconds() > 0 || staleAfter.minutes() > 0 || staleAfter.hours() > 0 || staleAfter.days() > 0 || staleAfter.months() > 0 || staleAfter.years() > 0) {
            verification.setStaleCheck(true);
            verification.setStaleSeconds(staleAfter.seconds());
            verification.setStaleMinutes(staleAfter.minutes());
            verification.setStaleHours(staleAfter.hours());
            verification.setStaleDays(staleAfter.days());
            verification.setStaleMonths(staleAfter.months());
            verification.setStaleYears(staleAfter.years());
        }
        verification.setBodyHashRequired(v.bodyHashRequired());
        return verification;
    }
}

