/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.RedirectionException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.internal.AbortedResponse;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestContextImpl;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestHeaders;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponseContextImpl;
import org.jboss.resteasy.core.interception.jaxrs.ClientWriterInterceptorContext;
import org.jboss.resteasy.specimpl.MultivaluedTreeMap;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.DelegatingOutputStream;
import org.jboss.resteasy.util.Types;

public class ClientInvocation
implements Invocation {
    protected ResteasyClient client;
    protected ClientRequestHeaders headers;
    protected String method;
    protected Object entity;
    protected Type entityGenericType;
    protected Class<?> entityClass;
    protected Annotation[] entityAnnotations;
    protected ClientConfiguration configuration;
    protected URI uri;
    protected DelegatingOutputStream delegatingOutputStream = new DelegatingOutputStream();
    protected OutputStream entityStream = this.delegatingOutputStream;

    public ClientInvocation(ResteasyClient client, URI uri, ClientRequestHeaders headers, ClientConfiguration parent) {
        this.uri = uri;
        this.client = client;
        this.configuration = new ClientConfiguration(parent);
        this.headers = headers;
    }

    ClientInvocation(ClientInvocation clientInvocation) {
        this.client = clientInvocation.client;
        this.configuration = new ClientConfiguration(clientInvocation.configuration);
        this.headers = new ClientRequestHeaders(this.configuration);
        MultivaluedTreeMap.copy(clientInvocation.headers.getHeaders(), this.headers.headers);
        this.method = clientInvocation.method;
        this.entity = clientInvocation.entity;
        this.entityGenericType = clientInvocation.entityGenericType;
        this.entityClass = clientInvocation.entityClass;
        this.entityAnnotations = clientInvocation.entityAnnotations;
        this.uri = clientInvocation.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T extractResult(GenericType<T> responseType, Response response, Annotation[] annotations) {
        int status = response.getStatus();
        if (status >= 200 && status < 300) {
            try {
                if (response.getMediaType() == null) {
                    T t = null;
                    return t;
                }
                Object rtn = response.readEntity(responseType, annotations);
                if ((InputStream.class.isInstance(rtn) || Reader.class.isInstance(rtn)) && response instanceof ClientResponse) {
                    ClientResponse clientResponse = (ClientResponse)response;
                    clientResponse.noReleaseConnection();
                }
                Object object = rtn;
                return (T)object;
            }
            catch (WebApplicationException wae) {
                try {
                    response.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw wae;
            }
            catch (Throwable throwable) {
                try {
                    response.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ResponseProcessingException(response, throwable);
            }
            finally {
                if (response.getMediaType() == null) {
                    response.close();
                }
            }
        }
        try {
            String s = (String)String.class.cast(response.getHeaders().getFirst((Object)"resteasy.buffer.exception.entity"));
            if (s == null || Boolean.parseBoolean(s)) {
                response.bufferEntity();
            } else if (response instanceof ClientResponse) {
                try {
                    ((ClientResponse)((Object)ClientResponse.class.cast(response))).releaseConnection();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (status >= 300 && status < 400) {
                throw new RedirectionException(response);
            }
            T t = ClientInvocation.handleErrorStatus(response);
            return t;
        }
        finally {
            if (response.getMediaType() == null) {
                response.close();
            }
        }
    }

    public static <T> T handleErrorStatus(Response response) {
        int status = response.getStatus();
        switch (status) {
            case 400: {
                throw new BadRequestException(response);
            }
            case 401: {
                throw new NotAuthorizedException(response);
            }
            case 403: {
                throw new ForbiddenException(response);
            }
            case 404: {
                throw new NotFoundException(response);
            }
            case 405: {
                throw new NotAllowedException(response);
            }
            case 406: {
                throw new NotAcceptableException(response);
            }
            case 415: {
                throw new NotSupportedException(response);
            }
            case 500: {
                throw new InternalServerErrorException(response);
            }
            case 503: {
                throw new ServiceUnavailableException(response);
            }
        }
        if (status >= 400 && status < 500) {
            throw new ClientErrorException(response);
        }
        if (status >= 500) {
            throw new ServerErrorException(response);
        }
        throw new WebApplicationException(response);
    }

    public ClientConfiguration getClientConfiguration() {
        return this.configuration;
    }

    public ResteasyClient getClient() {
        return this.client;
    }

    public DelegatingOutputStream getDelegatingOutputStream() {
        return this.delegatingOutputStream;
    }

    public void setDelegatingOutputStream(DelegatingOutputStream delegatingOutputStream) {
        this.delegatingOutputStream = delegatingOutputStream;
    }

    public OutputStream getEntityStream() {
        return this.entityStream;
    }

    public void setEntityStream(OutputStream entityStream) {
        this.entityStream = entityStream;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public void setEntityAnnotations(Annotation[] entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHeaders(ClientRequestHeaders headers) {
        this.headers = headers;
    }

    public Map<String, Object> getMutableProperties() {
        return this.configuration.getMutableProperties();
    }

    public Object getEntity() {
        return this.entity;
    }

    public Type getEntityGenericType() {
        return this.entityGenericType;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public ClientRequestHeaders getHeaders() {
        return this.headers;
    }

    public void setEntity(Entity<?> entity) {
        if (entity == null) {
            this.entity = null;
            this.entityAnnotations = null;
            this.entityClass = null;
            this.entityGenericType = null;
        } else {
            Object ent = entity.getEntity();
            this.setEntityObject(ent);
            this.entityAnnotations = entity.getAnnotations();
            Variant v = entity.getVariant();
            this.headers.setMediaType(v.getMediaType());
            this.headers.setLanguage(v.getLanguage());
            this.headers.header("Content-Encoding", null);
            this.headers.header("Content-Encoding", v.getEncoding());
        }
    }

    public void setEntityObject(Object ent) {
        if (ent instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)ent;
            this.entityClass = genericEntity.getRawType();
            this.entityGenericType = genericEntity.getType();
            this.entity = genericEntity.getEntity();
        } else if (ent == null) {
            this.entity = null;
            this.entityClass = null;
            this.entityGenericType = null;
        } else {
            this.entity = ent;
            this.entityClass = ent.getClass();
            this.entityGenericType = ent.getClass();
        }
    }

    public void writeRequestBody(OutputStream outputStream) throws IOException {
        if (this.entity == null) {
            return;
        }
        WriterInterceptor[] interceptors = this.getWriterInterceptors();
        ClientWriterInterceptorContext ctx = new ClientWriterInterceptorContext(interceptors, this.configuration.getProviderFactory(), this.entity, this.entityClass, this.entityGenericType, this.entityAnnotations, this.headers.getMediaType(), this.headers.getHeaders(), outputStream, this.getMutableProperties());
        ctx.proceed();
    }

    public WriterInterceptor[] getWriterInterceptors() {
        return this.configuration.getWriterInterceptors(null, null);
    }

    public ClientRequestFilter[] getRequestFilters() {
        return this.configuration.getRequestFilters(null, null);
    }

    public ClientResponseFilter[] getResponseFilters() {
        return this.configuration.getResponseFilters(null, null);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invoke() {
        Providers current = (Providers)ResteasyProviderFactory.getContextData(Providers.class);
        ResteasyProviderFactory.pushContext(Providers.class, (Object)this.configuration);
        try {
            ClientResponse response;
            ClientRequestContextImpl requestContext = new ClientRequestContextImpl(this);
            ClientRequestFilter[] requestFilters = this.getRequestFilters();
            ClientResponse aborted = null;
            if (requestFilters != null && requestFilters.length > 0) {
                for (ClientRequestFilter filter : requestFilters) {
                    try {
                        filter.filter((ClientRequestContext)requestContext);
                        if (requestContext.getAbortedWithResponse() == null) continue;
                        aborted = new AbortedResponse(this.configuration, requestContext.getAbortedWithResponse());
                        break;
                    }
                    catch (ProcessingException e) {
                        throw e;
                    }
                    catch (WebApplicationException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw new ProcessingException((Throwable)e);
                    }
                }
            }
            if ((response = aborted) == null) {
                response = this.client.httpEngine().invoke(this);
            }
            response.setProperties(this.configuration.getMutableProperties());
            ClientResponseFilter[] responseFilters = this.getResponseFilters();
            if (responseFilters != null && responseFilters.length > 0) {
                ClientResponseContextImpl responseContext = new ClientResponseContextImpl(response);
                for (ClientResponseFilter filter : responseFilters) {
                    try {
                        filter.filter((ClientRequestContext)requestContext, (ClientResponseContext)responseContext);
                    }
                    catch (ResponseProcessingException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw new ResponseProcessingException((Response)response, (Throwable)e);
                    }
                }
            }
            ClientResponse clientResponse = response;
            return clientResponse;
        }
        finally {
            ResteasyProviderFactory.popContextData(Providers.class);
            if (current != null) {
                ResteasyProviderFactory.pushContext(Providers.class, (Object)current);
            }
        }
    }

    public <T> T invoke(Class<T> responseType) {
        Response response = this.invoke();
        if (Response.class.equals(responseType)) {
            return (T)response;
        }
        return ClientInvocation.extractResult(new GenericType(responseType), response, null);
    }

    public <T> T invoke(GenericType<T> responseType) {
        Response response = this.invoke();
        if (responseType.getRawType().equals(Response.class)) {
            return (T)response;
        }
        return ClientInvocation.extractResult(responseType, response, null);
    }

    public Future<Response> submit() {
        return this.client.asyncInvocationExecutor().submit(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                return ClientInvocation.this.invoke();
            }
        });
    }

    public <T> Future<T> submit(final Class<T> responseType) {
        return this.client.asyncInvocationExecutor().submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return ClientInvocation.this.invoke(responseType);
            }
        });
    }

    public <T> Future<T> submit(final GenericType<T> responseType) {
        return this.client.asyncInvocationExecutor().submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return ClientInvocation.this.invoke(responseType);
            }
        });
    }

    public <T> Future<T> submit(InvocationCallback<T> callback) {
        GenericType<Object> genericType = new GenericType<Object>(){};
        Type[] typeInfo = Types.getActualTypeArgumentsOfAnInterface(callback.getClass(), InvocationCallback.class);
        if (typeInfo != null) {
            genericType = new GenericType(typeInfo[0]);
        }
        GenericType<Object> responseType = genericType;
        return this.client.asyncInvocationExecutor().submit(new Callable<T>((GenericType)responseType, callback){
            final /* synthetic */ GenericType val$responseType;
            final /* synthetic */ InvocationCallback val$callback;
            {
                this.val$responseType = genericType;
                this.val$callback = invocationCallback;
            }

            @Override
            public T call() throws Exception {
                Object result = null;
                try {
                    result = ClientInvocation.this.invoke(this.val$responseType);
                }
                catch (Exception e) {
                    this.val$callback.failed((Throwable)e);
                    throw e;
                }
                try {
                    this.val$callback.completed(result);
                    Object t = result;
                    return t;
                }
                finally {
                    if (result != null && result instanceof Response) {
                        ((Response)result).close();
                    }
                }
            }
        });
    }

    public Invocation property(String name, Object value) {
        this.configuration.property(name, value);
        return this;
    }
}

