/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientWebTarget;

public class ResteasyClient
implements Client {
    protected volatile ClientHttpEngine httpEngine;
    protected volatile ExecutorService asyncInvocationExecutor;
    protected ClientConfiguration configuration;
    protected boolean closed;

    ResteasyClient(ClientHttpEngine httpEngine, ExecutorService asyncInvocationExecutor, ClientConfiguration configuration) {
        this.httpEngine = httpEngine;
        this.asyncInvocationExecutor = asyncInvocationExecutor;
        this.configuration = configuration;
    }

    public ClientHttpEngine httpEngine() {
        this.abortIfClosed();
        return this.httpEngine;
    }

    public ExecutorService asyncInvocationExecutor() {
        return this.asyncInvocationExecutor;
    }

    public void abortIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Client is closed.");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        try {
            this.httpEngine.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration getConfiguration() {
        this.abortIfClosed();
        return this.configuration;
    }

    public SSLContext getSslContext() {
        this.abortIfClosed();
        return this.httpEngine().getSslContext();
    }

    public HostnameVerifier getHostnameVerifier() {
        this.abortIfClosed();
        return this.httpEngine().getHostnameVerifier();
    }

    public ResteasyClient property(String name, Object value) {
        this.abortIfClosed();
        this.configuration.property(name, value);
        return this;
    }

    public ResteasyClient register(Class<?> componentClass) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass);
        return this;
    }

    public ResteasyClient register(Class<?> componentClass, int priority) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, priority);
        return this;
    }

    public ResteasyClient register(Class<?> componentClass, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, (Class[])contracts);
        return this;
    }

    public ResteasyClient register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, (Map)contracts);
        return this;
    }

    public ResteasyClient register(Object component) {
        this.abortIfClosed();
        this.configuration.register(component);
        return this;
    }

    public ResteasyClient register(Object component, int priority) {
        this.abortIfClosed();
        this.configuration.register(component, priority);
        return this;
    }

    public ResteasyClient register(Object component, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(component, (Class[])contracts);
        return this;
    }

    public ResteasyClient register(Object component, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(component, (Map)contracts);
        return this;
    }

    public ResteasyWebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        this.abortIfClosed();
        if (uri == null) {
            throw new NullPointerException("uri was null");
        }
        return new ClientWebTarget(this, uri, this.configuration);
    }

    public ResteasyWebTarget target(URI uri) throws NullPointerException {
        this.abortIfClosed();
        if (uri == null) {
            throw new NullPointerException("uri was null");
        }
        return new ClientWebTarget(this, uri, this.configuration);
    }

    public ResteasyWebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        this.abortIfClosed();
        if (uriBuilder == null) {
            throw new NullPointerException("uriBuilder was null");
        }
        return new ClientWebTarget(this, uriBuilder, this.configuration);
    }

    public ResteasyWebTarget target(Link link) throws NullPointerException {
        this.abortIfClosed();
        if (link == null) {
            throw new NullPointerException("link was null");
        }
        URI uri = link.getUri();
        return new ClientWebTarget(this, uri, this.configuration);
    }

    public Invocation.Builder invocation(Link link) throws NullPointerException, IllegalArgumentException {
        this.abortIfClosed();
        if (link == null) {
            throw new NullPointerException("link was null");
        }
        ResteasyWebTarget target = this.target(link);
        if (link.getType() != null) {
            return target.request(new String[]{link.getType()});
        }
        return target.request();
    }
}

