/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.client.util.authentication.basic;

import dev.resteasy.client.util.authentication.AuthorizationProcessor;
import dev.resteasy.client.util.authentication.UserCredentials;
import dev.resteasy.client.util.common.ByteStringBuilder;
import dev.resteasy.client.util.logging.ClientMessages;
import jakarta.ws.rs.client.ClientRequestContext;
import java.util.Base64;
import java.util.List;
import java.util.Objects;

public class BasicAuthorizationProcessor
implements AuthorizationProcessor {
    private static final String CHALLENGE_PREFIX = "Basic ";
    private final UserCredentials credentials;

    public BasicAuthorizationProcessor(UserCredentials credentials) {
        this.credentials = Objects.requireNonNull(credentials, ClientMessages.MESSAGES.requiredValue("credentials"));
    }

    @Override
    public String createRequestHeader(ClientRequestContext requestContext) {
        ByteStringBuilder builder = new ByteStringBuilder(128).append(this.credentials.getUsername()).append(':').append(this.credentials.getPassword());
        return CHALLENGE_PREFIX + Base64.getEncoder().encodeToString(builder.toArray());
    }

    @Override
    public String createRequestHeader(ClientRequestContext requestContext, List<String> authenticateHeader) {
        boolean process = false;
        for (String challenge : authenticateHeader) {
            if (!challenge.regionMatches(true, 0, CHALLENGE_PREFIX, 0, CHALLENGE_PREFIX.length())) continue;
            process = true;
            break;
        }
        return process ? this.createRequestHeader(requestContext) : null;
    }
}

