/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.client.util.authentication.digest;

import dev.resteasy.client.util.authentication.AuthorizationProcessor;
import dev.resteasy.client.util.authentication.UserCredentials;
import dev.resteasy.client.util.authentication.digest.DigestHashBuilder;
import dev.resteasy.client.util.authentication.digest.DigestScheme;
import dev.resteasy.client.util.common.Bytes;
import dev.resteasy.client.util.common.LimitMap;
import dev.resteasy.client.util.logging.ClientMessages;
import jakarta.ws.rs.client.ClientRequestContext;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DigestAuthorizationProcessor
implements AuthorizationProcessor {
    private static final String CHALLENGE_PREFIX = "Digest ";
    private final UserCredentials credentials;
    private final Map<URI, DigestScheme> cache;
    private final SecureRandom generator;

    public DigestAuthorizationProcessor(UserCredentials credentials) {
        this(credentials, 100);
    }

    public DigestAuthorizationProcessor(UserCredentials credentials, int limit) {
        this.credentials = Objects.requireNonNull(credentials, ClientMessages.MESSAGES.requiredValue("credentials"));
        this.cache = limit > 0 ? LimitMap.of(limit) : null;
        this.generator = new SecureRandom();
    }

    @Override
    public String createRequestHeader(ClientRequestContext requestContext) {
        DigestScheme digest;
        if (this.cache != null && (digest = this.cache.get(requestContext.getUri())) != null) {
            return this.createHeaderValue(digest, requestContext);
        }
        return null;
    }

    @Override
    public String createRequestHeader(ClientRequestContext requestContext, List<String> authenticateHeader) {
        for (String authHeader : authenticateHeader) {
            DigestScheme digestScheme;
            if (!authHeader.regionMatches(true, 0, CHALLENGE_PREFIX, 0, CHALLENGE_PREFIX.length()) || (digestScheme = DigestScheme.of(authHeader)) == null) continue;
            return this.createHeaderValue(digestScheme, requestContext);
        }
        return null;
    }

    @Override
    public void reset(ClientRequestContext requestContext) {
        if (this.cache != null) {
            this.cache.remove(requestContext.getUri());
        }
    }

    private String createHeaderValue(DigestScheme digest, ClientRequestContext requestContext) {
        String response;
        Object entity;
        if (digest.algorithm == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(100);
        result.append(CHALLENGE_PREFIX);
        String username = this.credentials.getUsername();
        if (digest.userhash) {
            DigestAuthorizationProcessor.append(result, "username", digest.algorithm.builder().append(username).build());
            DigestAuthorizationProcessor.append(result, "userhash", true, false);
        } else {
            boolean encode = false;
            for (char c : username.toCharArray()) {
                if (c >= '\u0000' && c < '\u007f') continue;
                encode = true;
                break;
            }
            if (encode) {
                DigestAuthorizationProcessor.append(result, "username*", "UTF-8''" + URLEncoder.encode(username, StandardCharsets.UTF_8), false);
            } else {
                DigestAuthorizationProcessor.append(result, "username", username);
            }
        }
        DigestAuthorizationProcessor.append(result, "realm", digest.realm);
        DigestAuthorizationProcessor.append(result, "qop", digest.qop, false);
        DigestAuthorizationProcessor.append(result, "nonce", digest.nonce);
        DigestAuthorizationProcessor.append(result, "opaque", digest.opaque);
        DigestAuthorizationProcessor.append(result, "algorithm", digest.algorithm, false);
        String uri = DigestAuthorizationProcessor.relativeUri(requestContext.getUri());
        DigestAuthorizationProcessor.append(result, "uri", uri);
        byte[] bytes = new byte[32];
        this.generator.nextBytes(bytes);
        String cnonce = Bytes.bytesToHexString(bytes);
        String ha1 = digest.algorithm.isSession() ? digest.algorithm.builder().append(username).append(digest.realm).append(this.credentials.getPassword()).append(digest.nonce).append(cnonce).build() : digest.algorithm.builder().append(username).append(digest.realm).append(this.credentials.getPassword()).build();
        DigestHashBuilder a2Builder = digest.algorithm.builder().append(requestContext.getMethod()).append(uri);
        if ("auth-init".equalsIgnoreCase(digest.qop) && (entity = requestContext.getEntity()) != null) {
            a2Builder.append(digest.algorithm.builder().append(entity).build());
        }
        String ha2 = a2Builder.build();
        if (digest.qop == null) {
            response = digest.algorithm.builder().append(ha1).append(digest.nonce).append(ha2).build();
        } else {
            DigestAuthorizationProcessor.append(result, "cnonce", cnonce);
            String nc = String.format("%08x", digest.nc.incrementAndGet());
            DigestAuthorizationProcessor.append(result, "nc", nc, false);
            response = digest.algorithm.builder().append(ha1).append(digest.nonce).append(nc).append(cnonce).append(digest.qop).append(ha2).build();
        }
        DigestAuthorizationProcessor.append(result, "response", response);
        if (this.cache != null) {
            this.cache.put(requestContext.getUri(), digest);
        }
        return result.toString();
    }

    private static void append(StringBuilder sb, String key, String value) {
        DigestAuthorizationProcessor.append(sb, key, value, true);
    }

    private static void append(StringBuilder sb, String key, Object value, boolean quoted) {
        if (value != null) {
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
                sb.append(',');
            }
            sb.append(key).append('=');
            if (quoted) {
                sb.append('\"');
            }
            sb.append(value);
            if (quoted) {
                sb.append('\"');
            }
        }
    }

    private static String relativeUri(URI uri) {
        if (uri == null) {
            return null;
        }
        String query = uri.getRawQuery();
        return uri.getRawPath() + (String)(query != null && query.length() > 0 ? "?" + query : "");
    }
}

