/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.client.util.authentication;

import dev.resteasy.client.util.authentication.AuthorizationProcessor;
import dev.resteasy.client.util.common.LimitMap;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

@ConstrainedTo(value=RuntimeType.CLIENT)
public class HttpAuthorizationFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger LOGGER = Logger.getLogger(HttpAuthorizationFilter.class);
    private static final String REQUEST_PROCESSED = "org.jboss.resteasy.client.authentication.request.processed";
    private static final String RESPONSE_PROCESSED = "org.jboss.resteasy.client.authentication.response.processed";
    private final Collection<AuthorizationProcessor> processors;
    private final Map<String, AuthorizationProcessor> cache;

    public HttpAuthorizationFilter(AuthorizationProcessor ... processors) {
        this(100, Arrays.asList(processors));
    }

    public HttpAuthorizationFilter(int limit, AuthorizationProcessor ... processors) {
        this(limit, Arrays.asList(processors));
    }

    public HttpAuthorizationFilter(int limit, Collection<AuthorizationProcessor> processors) {
        this.processors = new ArrayList<AuthorizationProcessor>(processors);
        this.cache = limit > 0 ? LimitMap.of(limit) : null;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (requestContext.hasProperty(REQUEST_PROCESSED) || requestContext.hasProperty(RESPONSE_PROCESSED)) {
            return;
        }
        if (requestContext.getHeaders().containsKey((Object)"Authorization")) {
            return;
        }
        requestContext.setProperty(REQUEST_PROCESSED, (Object)true);
        if (this.cache == null) {
            return;
        }
        String key = HttpAuthorizationFilter.createKey(requestContext);
        AuthorizationProcessor cached = this.cache.get(key);
        if (cached != null) {
            String value = cached.createRequestHeader(requestContext);
            if (value == null) {
                this.cache.remove(key);
                cached.reset(requestContext);
            } else {
                requestContext.setProperty(RESPONSE_PROCESSED, (Object)true);
                requestContext.getHeaders().add((Object)"Authorization", (Object)value);
            }
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (requestContext.getProperty(RESPONSE_PROCESSED) != null) {
            return;
        }
        if (responseContext.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            List authenticateHeader = (List)responseContext.getHeaders().get((Object)"WWW-Authenticate");
            for (AuthorizationProcessor processor : this.processors) {
                if (HttpAuthorizationFilter.repeatRequest(requestContext, responseContext, processor.createRequestHeader(requestContext, authenticateHeader))) {
                    if (this.cache == null) break;
                    this.cache.put(HttpAuthorizationFilter.createKey(requestContext), processor);
                    break;
                }
                processor.reset(requestContext);
                LOGGER.debugf("Failed to process request for type %s with processor %s", (Object)authenticateHeader, (Object)processor.getClass().getName());
            }
        }
    }

    private static boolean repeatRequest(ClientRequestContext request, ClientResponseContext response, String authHeader) {
        if (authHeader == null) {
            return false;
        }
        Client client = request.getClient();
        String method = request.getMethod();
        MediaType mediaType = request.getMediaType();
        Invocation.Builder builder = client.target(request.getUri()).request(new MediaType[]{mediaType});
        MultivaluedHashMap newHeaders = new MultivaluedHashMap();
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            if ("Authorization".equals(entry.getKey())) continue;
            newHeaders.put((Object)((String)entry.getKey()), (Object)((List)entry.getValue()));
        }
        newHeaders.add((Object)"Authorization", (Object)authHeader);
        builder.headers((MultivaluedMap)newHeaders);
        builder.property(RESPONSE_PROCESSED, (Object)true);
        Invocation invocation = request.getEntity() == null ? builder.build(method) : builder.build(method, Entity.entity((Object)request.getEntity(), (MediaType)request.getMediaType()));
        Response newResponse = invocation.invoke();
        if (newResponse.hasEntity()) {
            response.setEntityStream((InputStream)newResponse.readEntity(InputStream.class));
        }
        MultivaluedMap headers = response.getHeaders();
        headers.clear();
        headers.putAll((Map)newResponse.getStringHeaders());
        response.setStatus(newResponse.getStatus());
        return response.getStatus() != Response.Status.UNAUTHORIZED.getStatusCode();
    }

    private static String createKey(ClientRequestContext request) {
        URI requestUri = request.getUri();
        if (requestUri.getRawQuery() != null) {
            try {
                return HttpAuthorizationFilter.formatKey(new URI(requestUri.getScheme(), requestUri.getAuthority(), requestUri.getPath(), null, requestUri.getFragment()), request.getMethod());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return HttpAuthorizationFilter.formatKey(requestUri, request.getMethod());
    }

    private static String formatKey(URI requestUri, String method) {
        return String.format("%s:%s", requestUri, method);
    }
}

